/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer;

import java.io.IOException;
import java.io.Writer;

public class SpaceCharCompactionWriter
extends Writer {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Writer writer;
    private boolean ignoreSpace;

    public SpaceCharCompactionWriter(Writer out) {
        this.writer = out;
        this.ignoreSpace = false;
    }

    public void flush() throws IOException {
        this.ignoreSpace = false;
        this.writer.flush();
    }

    public void close() throws IOException {
        this.ignoreSpace = false;
        this.writer.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        boolean isSpace = false;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            int j;
            if (this.ignoreSpace) {
                for (j = i; j < end && (isSpace = Character.isSpaceChar(cbuf[j])); ++j) {
                }
                i = isSpace ? j : j - 1;
            } else {
                while (j < end && !(isSpace = Character.isSpaceChar(cbuf[j]))) {
                    ++j;
                }
                this.writer.write(cbuf, i, isSpace ? j - i + 1 : j - i);
                i = isSpace ? j - 1 : j;
            }
            this.ignoreSpace = isSpace;
        }
    }
}

