/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer;

import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedWriter;
import com.ibm.es.nuvo.normalizer.Normalizer;
import com.ibm.es.nuvo.normalizer.map.MapNormalizedWriter;
import com.ibm.es.nuvo.normalizer.map.NormType;
import java.io.IOException;
import java.io.Writer;

public class NormalizedStringBufferType2
extends NormalizedStringBuffer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public NormalizedStringBufferType2() {
        this(16);
    }

    public NormalizedStringBufferType2(int capacity) {
        super(new NormalizedStringBuffer.Plugin(){

            public NormalizedWriter createWriter(Writer writer) {
                return new NormalizedWriter(new MapNormalizedWriter(writer, NormType.TYPE2), new LowerCaseNormalizer());
            }
        }, capacity);
    }

    private static class LowerCaseNormalizer
    extends Normalizer {
        private static final int DEFAULT_BUFFER_SIZE = 16;
        private char[] buffer;

        private LowerCaseNormalizer() {
            this(16);
        }

        private LowerCaseNormalizer(int bufSize) {
            super(null);
            this.buffer = new char[bufSize];
        }

        public Normalizer append(char[] chars, int off, int len) throws IOException {
            int end = off + len;
            int curOff = 0;
            for (int i = off; i < end; ++i) {
                if (curOff + 1 > this.buffer.length) {
                    this.writer.write(this.buffer, 0, curOff);
                    curOff = 0;
                }
                this.buffer[curOff++] = Character.toLowerCase(chars[i]);
            }
            if (curOff > 0) {
                this.writer.write(this.buffer, 0, curOff);
                curOff = 0;
            }
            return this;
        }

        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            int curOff = 0;
            for (int i = start; i < end; ++i) {
                if (curOff + 1 > this.buffer.length) {
                    this.writer.write(this.buffer, 0, curOff);
                    curOff = 0;
                }
                this.buffer[curOff++] = Character.toLowerCase(csq.charAt(i));
            }
            if (curOff > 0) {
                this.writer.write(this.buffer, 0, curOff);
                curOff = 0;
            }
            return this;
        }

        public Appendable append(char c) throws IOException {
            this.writer.append(Character.toLowerCase(c));
            return this;
        }
    }
}

