/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer;

import com.ibm.es.nuvo.normalizer.NormalizedWriter;
import com.ibm.es.nuvo.normalizer.StringBuilderWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class NormalizedStringBuffer
implements Appendable,
CharSequence {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final int INIT_SIZE = 16;
    private NormalizedWriter writer;
    private StringBuilderWriter builder;

    protected NormalizedStringBuffer(Plugin plugin, int capacity) {
        this.builder = new StringBuilderWriter(new StringBuilder(capacity));
        this.writer = plugin.createWriter(this.builder);
    }

    public final NormalizedStringBuffer append(char c) {
        try {
            this.writer.append(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public final NormalizedStringBuffer append(char[] str) {
        return this.append(str, 0, str.length);
    }

    public final NormalizedStringBuffer append(char[] str, int offset, int len) {
        try {
            this.writer.write(str, offset, len);
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return this;
    }

    public final NormalizedStringBuffer append(CharSequence sb) {
        return this.append(sb, 0, sb.length());
    }

    public final NormalizedStringBuffer append(CharSequence sb, int start, int end) {
        try {
            this.writer.append(sb, start, end);
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return this;
    }

    public final void setLength(int newLength) {
        this.length();
        if (newLength > 0) {
            this.builder.setLength(newLength);
        } else {
            this.reset();
        }
    }

    public final int length() {
        try {
            this.writer.flush(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.builder.length();
    }

    public String substring(int start, int end) {
        try {
            this.writer.flush(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.builder.substring(start, end);
    }

    public final char charAt(int i) {
        return this.builder.charAt(i);
    }

    public final CharSequence subSequence(int start, int end) {
        try {
            this.writer.flush(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.builder.subSequence(start, end);
    }

    public final String toString() {
        try {
            this.writer.flush(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.builder.toString();
    }

    public NormalizedStringBuffer appendCodePoint(int cp) {
        try {
            this.writer.appendCodePoint(cp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public void reset() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.builder.reset();
    }

    public static interface Plugin {
        public NormalizedWriter createWriter(Writer var1);
    }
}

