/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.normalizer;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.normalizer.NormalizerConfigurationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class MimetypeNormalizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String MIMETYPES_FILE = "mimetypes.xml";
    private static MimetypeNormalizer instance;
    private final Map<String, String> mimetypeMaps = new HashMap<String, String>();

    private static synchronized MimetypeNormalizer instance() {
        if (instance == null) {
            instance = new MimetypeNormalizer();
        }
        return instance;
    }

    public static String normalize(String key) {
        if (key == null) {
            return null;
        }
        String normalized = MimetypeNormalizer.instance().mimetypeMaps.get(key = key.toLowerCase());
        if (normalized != null) {
            return normalized;
        }
        if (key.length() > 0 && key.charAt(0) != '.' && key.indexOf(47) == -1) {
            StringBuilder buf = new StringBuilder().append('.').append(key);
            return MimetypeNormalizer.instance().mimetypeMaps.get(buf.toString());
        }
        return null;
    }

    private MimetypeNormalizer() {
        HashMap mappings = new HashMap();
        String mimetypeCfg = GlobalConfiguration.getConfiguration().getConfigPath() + File.separator + MIMETYPES_FILE;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(mimetypeCfg));
            if (in != null) {
                new MimetypeConfigReader(in, mappings);
                ((InputStream)in).close();
            }
            for (Map.Entry entry : mappings.entrySet()) {
                String key = (String)entry.getKey();
                String mime = (String)entry.getValue();
                String normalized = (String)mappings.get(mime);
                if (normalized != null) {
                    this.mimetypeMaps.put(key, normalized);
                    continue;
                }
                this.mimetypeMaps.put(key, mime);
            }
        }
        catch (ParserConfigurationException e) {
            Loggers.logger.log(new NormalizerConfigurationException(mimetypeCfg, (Throwable)e));
        }
        catch (SAXException e) {
            Loggers.logger.log(new NormalizerConfigurationException(mimetypeCfg, (Throwable)e));
        }
        catch (IOException e) {
            Loggers.logger.log(new NormalizerConfigurationException(mimetypeCfg, (Throwable)e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MimetypeConfigReader
    extends DefaultHandler {
        private static final int P = 1;
        private static final int PP = 16;
        private static final int EXM = 64;
        private static final int EXMMT = 1024;
        private static final int EXMEX = 1025;
        private static final int MN = 80;
        private static final int MNNM = 1280;
        private static final int MNMT = 1281;
        private static final int SM = 96;
        private static final int SMMM = 1536;
        private static final int SMCT = 1537;
        private Map<String, String> mappings;
        private StringBuilder value = new StringBuilder();
        private List<String> list = new ArrayList<String>();
        private String mimetype;
        private int state = 1;
        private int section = 1;

        private MimetypeConfigReader(InputStream input, Map<String, String> maps) throws ParserConfigurationException, SAXException, IOException {
            this.mappings = maps;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(input, (DefaultHandler)this);
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            String name = qname;
            if ("Mimetypes".equals(name)) {
                this.section = 16;
                this.state = 16;
            } else if ("ExtensionMapping".equals(name)) {
                this.section = 64;
                this.state = 64;
            } else if ("MappedMimetype".equals(name) && this.section == 64) {
                this.state = 1024;
                this.mimetype = atts.getValue("Name");
                this.list.clear();
            } else if ("Extension".equals(name) && this.section == 64) {
                this.state = 1025;
                this.value.setLength(0);
            } else if ("MimetypeNormalization".equals(name)) {
                this.state = 80;
                this.section = 80;
            } else if ("NormalizedMimetype".equals(name) && this.section == 80) {
                this.state = 1280;
                this.mimetype = atts.getValue("Name");
                this.list.clear();
            } else if ("Mimetype".equals(name) && this.section == 80) {
                this.state = 1281;
                this.value.setLength(0);
            } else if ("StellentMapping".equals(name)) {
                this.state = 96;
                this.section = 96;
            } else if ("MappedMimetype".equals(name) && this.section == 96) {
                this.state = 1536;
                this.mimetype = atts.getValue("Name");
                this.list.clear();
            } else if ("Contenttype".equals(name) && this.section == 96) {
                this.state = 1537;
                this.value.setLength(0);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            String name = qname;
            if ("ExtensionMapping".equals(name)) {
                this.state = 1;
                this.section = 1;
            } else if ("MappedMimetype".equals(name) && this.section == 64) {
                this.state = 64;
                this.map(this.list, this.mimetype);
            } else if ("Extension".equals(name) && this.section == 64) {
                this.list.add(this.value.toString());
                this.state = 1024;
            } else if ("MimetypeNormalization".equals(name)) {
                this.state = 1;
                this.section = 1;
            } else if ("NormalizedMimetype".equals(name) && this.section == 80) {
                this.state = 80;
                this.map(this.list, this.mimetype);
            } else if ("Mimetype".equals(name) && this.section == 80) {
                this.list.add(this.value.toString());
                this.state = 1280;
            } else if ("StellentMapping".equals(name)) {
                this.state = 1;
                this.section = 1;
            } else if ("MappedMimetype".equals(name) && this.section == 96) {
                this.state = 96;
                this.map(this.list, this.mimetype);
            } else if ("Contenttype".equals(name) && this.section == 96) {
                this.list.add(this.value.toString());
                this.state = 1536;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case 1025: 
                case 1281: 
                case 1537: {
                    this.value.append(ch, start, length);
                    break;
                }
            }
        }

        private void map(List<String> keyList, String mappedValue) {
            if (!keyList.isEmpty() && mappedValue != null && mappedValue.length() > 0) {
                for (int i = 0; i < keyList.size(); ++i) {
                    this.mappings.put(keyList.get(i).toLowerCase(), mappedValue);
                }
            }
        }
    }
}

