/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network.remote;

import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.p2p.P2PDispatcher;
import com.ibm.es.nuvo.network.p2p.P2PException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replicator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private LinkedBlockingQueue<ReplicatorTask> sendQueue = new LinkedBlockingQueue(MaxSendQueueSize);
    private static int MaxSendQueueSize = 30;
    private ReplicatorThread thread = new ReplicatorThread();
    private Vector<Node> nodes;
    private static Hashtable<String, Replicator> replicators = new Hashtable();

    public static Replicator getReplicator(String collectionId) {
        Replicator repl = replicators.get(collectionId);
        if (repl == null) {
            repl = new Replicator(new Node("localhost", 9888));
            replicators.put(collectionId, repl);
        }
        return repl;
    }

    private Replicator() {
        this.thread.start();
    }

    private Replicator(Node node) {
        this();
        this.nodes = new Vector(1);
        this.nodes.add(node);
    }

    private Replicator(Collection<Node> nodes) {
        this();
        this.nodes = new Vector(nodes.size());
        this.nodes.addAll(nodes);
    }

    public int send(Node node, String serviceName, String context, Properties properties, InputStream inputStream, OutputStream outputStream) throws P2PException {
        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
        return p2pDispatcher.sendMsg(node, serviceName, context, properties, inputStream, outputStream);
    }

    public void post(String serviceName, String context, Properties properties, byte[] data) throws InterruptedException {
        for (int i = 0; i < this.nodes.size(); ++i) {
            this.insertIntoQueue(new ReplicatorTask(this.nodes.get(i), serviceName, context, properties, data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LinkedBlockingQueue<ReplicatorTask> linkedBlockingQueue = this.sendQueue;
        synchronized (linkedBlockingQueue) {
            if (this.sendQueue.size() > 0) {
                try {
                    this.sendQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void insertIntoQueue(ReplicatorTask task) throws InterruptedException {
        this.sendQueue.offer(task, 60L, TimeUnit.SECONDS);
    }

    public void stop() throws InterruptedException {
        this.thread.setStop();
        this.thread.join();
    }

    public class ReplicatorThread
    extends Thread {
        public boolean stop = false;

        public void setStop() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                try {
                    ReplicatorTask task = (ReplicatorTask)Replicator.this.sendQueue.take();
                    task.run();
                    LinkedBlockingQueue linkedBlockingQueue = Replicator.this.sendQueue;
                    synchronized (linkedBlockingQueue) {
                        if (Replicator.this.sendQueue.size() == 0) {
                            Replicator.this.sendQueue.notify();
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (P2PException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ReplicatorTask {
        private Node node;
        private String context;
        private Properties properties;
        private InputStream inputStream;
        private OutputStream outputStream;
        private String serviceName;

        public ReplicatorTask(Node node, String serviceName, String context, Properties properties, byte[] data) {
            this.node = node;
            this.properties = properties;
            this.context = context;
            this.serviceName = serviceName;
            this.inputStream = null;
            if (data != null) {
                byte[] copyBuffer = new byte[data.length];
                System.arraycopy(data, 0, copyBuffer, 0, data.length);
                this.inputStream = new ByteArrayInputStream(copyBuffer);
            }
        }

        public int run() throws P2PException {
            P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
            return p2pDispatcher.sendMsg(this.node, this.serviceName, this.context, this.properties, this.inputStream, this.outputStream);
        }
    }
}

