/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network.remote;

import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.p2p.P2PDispatcher;
import com.ibm.es.nuvo.network.p2p.P2PServiceInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalIndexOutputService
implements P2PServiceInterface {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Hashtable<String, IndexOutput> indexOutputs = new Hashtable();
    private static LocalIndexOutputService service;
    public static final String ServiceName = "LocalIndexOutputService";
    public static String ActionKey;
    public static String CreateOutputKey;
    public static String GetDirectoryKey;
    public static String PathKey;
    public static String ObjectIdKey;
    public static String NameKey;
    public static String CloseKey;
    public static String FlushKey;
    public static String LengthKey;
    public static String SeekKey;
    public static String PosKey;
    public static String WriteByteKey;
    public static String ByteKey;
    public static String WriteBytesKey;
    public static String OffsetKey;

    @Override
    public int msgRecieved(Hashtable<String, String> params, Node sender, HttpServletRequest request, HttpServletResponse response) {
        String objectId = params.get(ObjectIdKey);
        IndexOutput indexOutput = this.indexOutputs.get(objectId);
        String action = params.get(ActionKey);
        try {
            if (action.equalsIgnoreCase(CloseKey)) {
                indexOutput.close();
            } else if (action.equalsIgnoreCase(FlushKey)) {
                indexOutput.flush();
            } else if (action.equalsIgnoreCase(SeekKey)) {
                indexOutput.seek(Long.parseLong(params.get(PosKey)));
            } else if (action.equalsIgnoreCase(WriteByteKey)) {
                indexOutput.writeByte(Byte.parseByte(params.get(ByteKey)));
            } else if (action.equalsIgnoreCase(WriteBytesKey)) {
                this.writeBytes(indexOutput, Integer.parseInt(params.get(OffsetKey)), Integer.parseInt(params.get(LengthKey)), request, response);
            }
            return 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 500;
        }
    }

    private void writeBytes(IndexOutput output, int offset, int length, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        output.writeBytes(os.toByteArray(), offset, length);
    }

    public static LocalIndexOutputService getService() {
        if (service == null) {
            service = new LocalIndexOutputService();
        }
        return service;
    }

    public LocalIndexOutputService() {
        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
        p2pDispatcher.addService(ServiceName, this);
    }

    public IndexOutput createOutput(FSDirectory directory, String objectId, String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IndexOutput output = directory.createOutput(name);
        this.indexOutputs.put(objectId, output);
        return output;
    }

    static {
        ActionKey = "action";
        CreateOutputKey = "createOutput";
        GetDirectoryKey = "getDirectory";
        PathKey = "path";
        ObjectIdKey = "LocalIndexOutputService.objectId";
        NameKey = "name";
        CloseKey = "close";
        FlushKey = "flush";
        LengthKey = "length";
        SeekKey = "seek";
        PosKey = "position";
        WriteByteKey = "writeByte";
        ByteKey = "byte";
        WriteBytesKey = "writeBytes";
        OffsetKey = "offset";
    }
}

