/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network.remote;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.p2p.P2PDispatcher;
import com.ibm.es.nuvo.network.p2p.P2PServiceInterface;
import com.ibm.es.nuvo.network.remote.LocalIndexOutputService;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFSDirectoryService
implements P2PServiceInterface {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String ServiceName = "FSDirectoryService";
    private Hashtable<String, FSDirectory> directories = new Hashtable();
    public static final String ActionKey = "action";
    public static final String CreateOutputKey = "createOutput";
    public static final String GetDirectoryKey = "getDirectory";
    public static final String PathKey = "path";
    public static final String ObjectIdKey = "LocalFSDirectory.objectId";
    public static final String NameKey = "name";
    public static final String CloseKey = "close";
    public static final String DeleteFileKey = "deleteFile";
    public static final String TouchFileKey = "touchFile";
    public static final String CollectionIdKey = "collectionId";
    public static final String IndexKey = "indexKey";
    public static final String TextIndex = "text";
    public static final String CacheIndex = "cache";
    public static LocalFSDirectoryService Service = null;
    public static Object writers = new Object();

    public static LocalFSDirectoryService getService() {
        if (Service == null) {
            Service = new LocalFSDirectoryService();
        }
        return Service;
    }

    private LocalFSDirectoryService() {
        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
        p2pDispatcher.addService(ServiceName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int msgRecieved(Hashtable<String, String> params, Node sender, HttpServletRequest request, HttpServletResponse response) {
        String action = params.get(ActionKey);
        try {
            if (action.equalsIgnoreCase(GetDirectoryKey)) {
                this.getDirectory(params.get(CollectionIdKey), params.get(ObjectIdKey), params.get(IndexKey), request, response);
            } else if (action.equalsIgnoreCase(CreateOutputKey)) {
                this.createOutput(params.get(ObjectIdKey), params.get(LocalIndexOutputService.ObjectIdKey), params.get(NameKey), request, response);
            } else if (action.equalsIgnoreCase(CloseKey)) {
                String objectId = params.get(ObjectIdKey);
                FSDirectory directory = this.directories.get(objectId);
                directory.close();
                this.directories.remove(objectId);
            } else if (action.equalsIgnoreCase(DeleteFileKey)) {
                FSDirectory directory = this.directories.get(params.get(ObjectIdKey));
                Object object = writers;
                synchronized (object) {
                    IndexWriter writer = new IndexWriter((Directory)directory, null, false);
                    writer.close();
                }
            } else if (action.equalsIgnoreCase(TouchFileKey)) {
                FSDirectory directory = this.directories.get(params.get(ObjectIdKey));
                directory.touchFile(params.get(NameKey));
            }
            return 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 500;
        }
    }

    private IndexOutput createOutput(String fsDirectoryObjectId, String indexOutputObjectId, String name, HttpServletRequest request, HttpServletResponse response) throws NumberFormatException, IOException {
        return LocalIndexOutputService.getService().createOutput(this.directories.get(fsDirectoryObjectId), indexOutputObjectId, name, request, response);
    }

    private FSDirectory getDirectory(String collectionId, String objectIdKey, String indexKey, HttpServletRequest request, HttpServletResponse response) throws IOException, ConfigurationManagerException {
        CollectionConfiguration config = ConfigurationManager.getConfigurationManager().getCollection(collectionId);
        IndexDescriptor descriptor = null;
        if (indexKey.equalsIgnoreCase(TextIndex)) {
            descriptor = config.getIndexDescriptorFor(IndexDescriptor.IndexType.Text);
        } else if (indexKey.equalsIgnoreCase(CacheIndex)) {
            descriptor = config.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
        }
        String path = descriptor.getAbsolutePath();
        FSDirectory directory = FSDirectory.getDirectory((String)path);
        this.directories.put(objectIdKey, directory);
        return directory;
    }
}

