/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network.p2p;

import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.NodeManager;
import com.ibm.es.nuvo.network.p2p.P2PException;
import com.ibm.es.nuvo.network.p2p.P2PServiceInterface;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2PDispatcher {
    protected static final int BadServiceName = 999;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static P2PDispatcher manager = null;
    private HashMap<String, P2PServiceInterface> listeners = new HashMap();

    public static P2PDispatcher getInstance() {
        if (manager == null) {
            manager = new P2PDispatcher();
        }
        return manager;
    }

    private P2PDispatcher() {
    }

    public int sendMsg(Node recipientNode, String recipientService, String context, Properties props, InputStream dataStream, OutputStream replyStream) throws P2PException {
        String remoteAddr = recipientNode.getIpAddress();
        int remotePort = recipientNode.getHttpPort();
        int responseCode = -1;
        try {
            InputStream is;
            String remoteContextBase = ContextType.P2P_Communication.getContextPath();
            String remoteContext = remoteContextBase + "/" + recipientService;
            if (context != null && context.length() > 0) {
                remoteContext = remoteContext + "/" + URLEncoder.encode(context, "UTF-8");
            }
            URL url = new URL("http", remoteAddr, remotePort, remoteContext);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            if (props != null) {
                Set<Map.Entry<Object, Object>> keyValues = props.entrySet();
                for (Map.Entry<Object, Object> entry : keyValues) {
                    connection.addRequestProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            byte[] buffer = new byte[2048];
            if (dataStream != null) {
                int br;
                OutputStream httpStream = connection.getOutputStream();
                while ((br = dataStream.read(buffer)) >= 0) {
                    httpStream.write(buffer, 0, br);
                }
            }
            responseCode = connection.getResponseCode();
            if (replyStream != null && (is = connection.getInputStream()) != null) {
                int br;
                while ((br = is.read(buffer)) >= 0) {
                    replyStream.write(buffer, 0, br);
                }
            }
            connection.disconnect();
        }
        catch (Exception e) {
            P2PException e2 = new P2PException("Error trying to communicate with peer at " + remoteAddr + " on port " + remotePort, (Throwable)e);
            throw e2;
        }
        return responseCode;
    }

    public void addService(String serviceName, P2PServiceInterface listener) {
        this.listeners.put(serviceName, listener);
    }

    public P2PServiceInterface removeService(String serviceName) {
        return this.listeners.remove(serviceName);
    }

    public void dispatchMsg(Hashtable<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        int indexSeparator;
        String serviceName = request.getPathInfo();
        if (serviceName.startsWith("/")) {
            serviceName = serviceName.substring(1);
        }
        if ((indexSeparator = serviceName.indexOf("/")) > 0) {
            serviceName = serviceName.substring(0, indexSeparator);
        }
        int responseCode = 999;
        P2PServiceInterface listener = this.listeners.get(serviceName);
        if (listener != null) {
            try {
                String sendingHost = request.getRemoteHost();
                int sendingPort = request.getRemotePort();
                Node sender = NodeManager.getInstance().getNodeFor(sendingHost, sendingPort);
                responseCode = listener.msgRecieved(params, sender, request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
                Loggers.logger.log(Level.SEVERE, "Error on dispatching P2P msg " + e);
            }
        }
        response.setStatus(responseCode);
    }
}

