/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network.datagram;

import com.ibm.es.nuvo.network.datagram.DatagramMessage;
import com.ibm.es.nuvo.network.datagram.DatagramPacketListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Vector;

public class DatagramService {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int PacketLength = 4096;
    private static final String SocketGroup = "230.10.10.10";
    private static final int SocketTimeoutInMillis = 2000;
    private static DatagramService datagramService = null;
    private Thread listenerThread = null;
    private MulticastSocket socket = null;
    private InetAddress socketGroupAddress = null;
    private Vector<DatagramPacketListener> listeners = new Vector();
    private SocketListener socketListener = null;
    private int socketPort = 0;
    private String msgGroupName = null;

    public static DatagramService getInstance() {
        if (datagramService == null) {
            datagramService = new DatagramService();
        }
        return datagramService;
    }

    private DatagramService() {
    }

    public synchronized void initialize(int port, String groupName) throws IOException {
        if (this.isInitialized()) {
            return;
        }
        this.msgGroupName = groupName;
        this.socketPort = port;
        this.socketGroupAddress = InetAddress.getByName(SocketGroup);
        this.socket = this.buildSocket();
        this.socketListener = new SocketListener(this.socket);
        this.listenerThread = new Thread(this.socketListener);
        this.listenerThread.start();
    }

    public synchronized void shutdown() throws IOException, InterruptedException {
        if (this.socket != null) {
            this.socketListener.setStop(true);
            this.listenerThread.join();
            this.releaseSocket(this.socket);
            this.socketGroupAddress = null;
            this.socket = null;
            this.socketListener = null;
            this.listenerThread = null;
            this.listeners.clear();
        }
    }

    public synchronized boolean isInitialized() {
        return this.socket != null;
    }

    public synchronized void sendMessageTo(String ipAddress, int port, DatagramMessage msg) throws IOException {
        byte[] bytes = this.msgToByteArray(msg);
        InetAddress netAddress = InetAddress.getByName(ipAddress);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, netAddress, port);
        this.sendMessage(packet);
    }

    public synchronized void broadcastMessage(DatagramMessage msg) throws IOException {
        byte[] bytes = this.msgToByteArray(msg);
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.socketGroupAddress, this.socketPort);
        this.sendMessage(packet);
    }

    public void startBroadcastMsgPeriodically(DatagramMessage msg, int[] broadcastFrequencies, int[] broadcastIntervals) {
        if (this.socketListener != null) {
            this.socketListener.addMsgToBroadcast(msg, broadcastFrequencies, broadcastIntervals);
        }
    }

    public void stopBroadcastMsgPeriodically(DatagramMessage msg) {
        if (this.socketListener != null) {
            this.socketListener.removeMsgFromBroadcast(msg);
        }
    }

    public void addDatagramPacketListener(DatagramPacketListener l) {
        this.listeners.add(l);
    }

    public void removeDatagramPacketListener(DatagramPacketListener l) {
        this.listeners.remove(l);
    }

    private void packetRecieved(DatagramPacket packet) {
        String ipAddress = packet.getAddress().getHostAddress();
        int port = packet.getPort();
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData());
        DatagramMessage msg = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            msg = (DatagramMessage)ois.readObject();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (msg != null && this.msgGroupName != null && !this.msgGroupName.equals(msg.getGroupName())) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            DatagramPacketListener l = this.listeners.elementAt(i);
            if (msg != null) {
                l.msgReceived(ipAddress, port, msg);
                continue;
            }
            l.packetReceived(ipAddress, port, packet.getData());
        }
    }

    private synchronized void sendMessage(DatagramPacket packet) throws IOException {
        if (packet.getLength() > 4096) {
            throw new RuntimeException("Packet data length (" + packet.getLength() + ") is greater than recieve buffer (" + 4096 + ")");
        }
        this.socket.send(packet);
    }

    private byte[] msgToByteArray(DatagramMessage msg) throws IOException {
        msg.setTimestamp(System.currentTimeMillis());
        msg.setGroupName(this.msgGroupName);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(msg);
        out.close();
        os.close();
        byte[] bytes = os.toByteArray();
        return bytes;
    }

    private MulticastSocket buildSocket() throws IOException {
        MulticastSocket sckt = new MulticastSocket(this.socketPort);
        sckt.setSoTimeout(2000);
        sckt.joinGroup(this.socketGroupAddress);
        return sckt;
    }

    private void releaseSocket(MulticastSocket sckt) throws IOException {
        if (sckt != null) {
            sckt.leaveGroup(this.socketGroupAddress);
            sckt.close();
        }
    }

    class SocketListener
    implements Runnable {
        private volatile boolean stop = false;
        private MulticastSocket mySocket = null;
        private Vector<DatagramMessage> broadcastMsgs = null;
        private Vector<int[]> broadcastMsgFrequencies = null;
        private Vector<int[]> broadcastMsgFrequencyIntervals = null;
        private Vector<Long> firstBroadcastTimes = null;
        private Vector<Long> lastBroadcastTimes = null;

        public SocketListener(MulticastSocket socket) {
            this.mySocket = socket;
            this.broadcastMsgs = new Vector();
            this.broadcastMsgFrequencies = new Vector();
            this.broadcastMsgFrequencyIntervals = new Vector();
            this.firstBroadcastTimes = new Vector();
            this.lastBroadcastTimes = new Vector();
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        public synchronized void addMsgToBroadcast(DatagramMessage msg, int[] broadcastFrequency, int[] broadcastInterval) {
            this.broadcastMsgs.add(msg);
            this.broadcastMsgFrequencies.add(broadcastFrequency);
            this.broadcastMsgFrequencyIntervals.add(broadcastInterval);
            this.firstBroadcastTimes.add(new Long(0L));
            this.lastBroadcastTimes.add(new Long(0L));
        }

        public synchronized void removeMsgFromBroadcast(DatagramMessage msg) {
            int index = this.broadcastMsgs.indexOf(msg);
            if (index >= 0) {
                this.broadcastMsgs.removeElementAt(index);
                this.broadcastMsgFrequencies.removeElementAt(index);
                this.broadcastMsgFrequencyIntervals.removeElementAt(index);
                this.firstBroadcastTimes.removeElementAt(index);
                this.lastBroadcastTimes.removeElementAt(index);
            }
        }

        public void run() {
            DatagramPacket packet = null;
            byte[] buffer = null;
            boolean buildNewBuffer = true;
            while (!this.stop) {
                if (buildNewBuffer) {
                    buffer = new byte[4096];
                    for (int i = buffer.length - 1; i >= 0; --i) {
                        buffer[i] = 0;
                    }
                }
                buildNewBuffer = false;
                packet = new DatagramPacket(buffer, buffer.length);
                try {
                    this.mySocket.receive(packet);
                    buildNewBuffer = true;
                    DatagramService.this.packetRecieved(packet);
                }
                catch (SocketTimeoutException e) {
                }
                catch (IOException e) {
                    buildNewBuffer = true;
                    e.printStackTrace();
                }
                this.processBroadcasts();
            }
        }

        private synchronized void processBroadcasts() {
            for (int i = 0; i < this.broadcastMsgs.size() && !this.stop; ++i) {
                int[] broadcastIntervals;
                int[] broadcastFrequency;
                long firstBroadcastTime;
                int broadcastInterval;
                long lastBroadcastTime;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (lastBroadcastTime = this.lastBroadcastTimes.get(i).longValue()) <= (long)(broadcastInterval = this.getIntervalToNextBroadcast(currentTime, firstBroadcastTime = this.firstBroadcastTimes.get(i).longValue(), broadcastFrequency = this.broadcastMsgFrequencies.get(i), broadcastIntervals = this.broadcastMsgFrequencyIntervals.get(i)))) continue;
                try {
                    DatagramMessage msg = this.broadcastMsgs.get(i);
                    DatagramService.getInstance().broadcastMessage(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.lastBroadcastTimes.removeElementAt(i);
                this.lastBroadcastTimes.add(i, new Long(currentTime));
                if (firstBroadcastTime != 0L) continue;
                this.firstBroadcastTimes.removeElementAt(i);
                this.firstBroadcastTimes.add(i, new Long(currentTime));
            }
        }

        private int getIntervalToNextBroadcast(long currentTime, long lastBroadcastTime, int[] frequencies, int[] intervals) {
            int interval = 0;
            long timeSinceLastBroadcast = currentTime - lastBroadcastTime;
            for (int i = 0; i < intervals.length && interval == 0; ++i) {
                if (timeSinceLastBroadcast >= (long)intervals[i] && intervals[i] >= 0) continue;
                interval = frequencies[i];
            }
            return interval;
        }
    }
}

