/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network;

import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.NodeConfigurationData;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static NodeManager nodeManager = null;

    private NodeManager() {
    }

    public static NodeManager getInstance() {
        if (nodeManager == null) {
            nodeManager = new NodeManager();
        }
        return nodeManager;
    }

    public boolean isMultiNode() {
        NodeConfigurationData data = this.getConfigData();
        return data.getNodes().size() > 0;
    }

    @Deprecated
    public boolean isDistributingNode() {
        NodeConfigurationData data = this.getConfigData();
        return data.isDistributingNode();
    }

    @Deprecated
    public void setDistributingNode(boolean distribute) throws ConfigurationManagerException {
        NodeConfigurationData data = this.getConfigDataForUpdate();
        data.setDistributingNode(distribute);
        this.saveConfigData(data);
    }

    public boolean isDistributingCollection(String collectionId) {
        NodeConfigurationData data = this.getConfigData();
        return data.getDistributingCollections().contains(collectionId);
    }

    public void addDistributingCollection(String collectionId) throws ConfigurationManagerException {
        NodeConfigurationData data = this.getConfigDataForUpdate();
        if (!data.getDistributingCollections().contains(collectionId)) {
            data.getDistributingCollections().add(collectionId);
            this.saveConfigData(data);
        }
    }

    public void removeDistributingCollection(String collectionId) throws ConfigurationManagerException {
        NodeConfigurationData data = this.getConfigDataForUpdate();
        if (data.getDistributingCollections().contains(collectionId)) {
            data.getDistributingCollections().remove(collectionId);
            this.saveConfigData(data);
        }
    }

    public synchronized Vector<Node> getNodeList(boolean onlyActiveNodes) {
        NodeConfigurationData data = this.getConfigData();
        Vector nodes = (Vector)data.getNodes().clone();
        if (onlyActiveNodes) {
            for (int i = nodes.size() - 1; i >= 0; --i) {
                if (((Node)nodes.get(i)).isActive()) continue;
                nodes.remove(i);
            }
        }
        return nodes;
    }

    public synchronized Node getNodeFor(String ipAddress, int port) {
        Node foundNode = null;
        NodeConfigurationData data = this.getConfigData();
        Vector<Node> nodeList = data.getNodes();
        for (int i = 0; i < nodeList.size() && foundNode == null; ++i) {
            Node n = nodeList.elementAt(i);
            if (port != n.getHttpPort() || !ipAddress.equals(n.getIpAddress())) continue;
            foundNode = n;
        }
        return foundNode;
    }

    private NodeConfigurationData getConfigData() {
        SettingsConfigurationManager mgr = SettingsConfigurationManager.getConfigurationManager();
        NodeConfigurationData data = (NodeConfigurationData)mgr.getSettings(SettingsConfigurationManager.SettingsType.NodeConfigurationData);
        return data;
    }

    private NodeConfigurationData getConfigDataForUpdate() {
        SettingsConfigurationManager mgr = SettingsConfigurationManager.getConfigurationManager();
        NodeConfigurationData data = (NodeConfigurationData)mgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.NodeConfigurationData);
        return data;
    }

    private void saveConfigData(NodeConfigurationData data) throws ConfigurationManagerException {
        SettingsConfigurationManager mgr = SettingsConfigurationManager.getConfigurationManager();
        mgr.updateStateObject(SettingsConfigurationManager.SettingsType.NodeConfigurationData, data);
    }

    public void initialize() {
    }

    public void shutdown() {
    }
}

