/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsObject;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeConfigurationData
implements SettingsObject {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String NodeConfigElement = "config";
    private static final String GroupNameElement = "group";
    private static final String PortElement = "discovery_port";
    private static final String DistributingNodeElement = "distributing_node";
    private static final String DistributingCollectionsElement = "distributing_collections";
    private static final String CollectionElement = "collection";
    private static final String NodeConfigFileName = "nodeConfiguration.xml";
    private String groupName = null;
    private int discoveryPort = 0;
    private boolean distributingNode = false;
    private Vector<Node> nodes = new Vector();
    private Vector<String> distributingCollections = new Vector();

    public int getDiscoveryPort() {
        return this.discoveryPort;
    }

    public void setDiscoveryPort(int discoveryPort) {
        this.discoveryPort = discoveryPort;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Vector<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Vector<Node> remoteNodes) {
        this.nodes = remoteNodes;
    }

    public Vector<String> getDistributingCollections() {
        return this.distributingCollections;
    }

    public void setDistributingCollections(Vector<String> distributingCollections) {
        this.distributingCollections = distributingCollections;
    }

    public void addDistributingCollection(String collectionId) {
        if (!this.distributingCollections.contains(collectionId)) {
            this.distributingCollections.add(collectionId);
        }
    }

    public boolean isDistributingNode() {
        return this.distributingNode;
    }

    public void setDistributingNode(boolean distributingNode) {
        this.distributingNode = distributingNode;
    }

    public Node buildRemoteNode() {
        Node n = new Node();
        this.nodes.add(n);
        return n;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        int i;
        XMLTagger xmlTagger = new XMLTagger(true, true);
        xmlTagger.openStartElement(NodeConfigElement);
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.closeTag();
        if (this.groupName != null) {
            xmlTagger.startElement(GroupNameElement);
            xmlTagger.writeText(this.groupName);
            xmlTagger.endElement(GroupNameElement);
        }
        if (this.discoveryPort != 0) {
            xmlTagger.startElement(PortElement);
            xmlTagger.writeText(String.valueOf(this.discoveryPort));
            xmlTagger.endElement(PortElement);
        }
        xmlTagger.startElement(DistributingNodeElement);
        xmlTagger.writeText(String.valueOf(this.distributingNode));
        xmlTagger.endElement(DistributingNodeElement);
        if (this.distributingCollections != null && this.distributingCollections.size() > 0) {
            xmlTagger.startElement(DistributingCollectionsElement);
            for (i = 0; i < this.distributingCollections.size(); ++i) {
                xmlTagger.startElement(CollectionElement);
                xmlTagger.writeText(this.distributingCollections.get(i));
                xmlTagger.endElement(CollectionElement);
            }
            xmlTagger.endElement(DistributingCollectionsElement);
        }
        if (this.nodes != null) {
            for (i = 0; i < this.nodes.size(); ++i) {
                Node n = this.nodes.get(i);
                n.writeTo(xmlTagger);
            }
        }
        xmlTagger.endElement(NodeConfigElement);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    @Override
    public void loadFrom(InputStream is) throws ExtendedException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String basePath = "/config/";
        tree.addPath(basePath + GroupNameElement, "setGroupName");
        tree.addPath(basePath + PortElement, "setDiscoveryPort", Integer.TYPE);
        tree.addPath(basePath + DistributingNodeElement, "setDistributingNode", Boolean.TYPE);
        tree.addPath(basePath + DistributingCollectionsElement + "/" + CollectionElement, "addDistributingCollection");
        tree.addSetSubcomponent(basePath + "node", "buildRemoteNode");
        Node.prepareParseTree(basePath, tree);
        parser.parse(is, tree, this);
    }

    @Override
    public String getPersistantFileName() {
        StringBuffer sb = new StringBuffer(200);
        GlobalConfiguration gc = GlobalConfiguration.getConfiguration();
        sb.append(gc.getConfigPath());
        sb.append(File.separator);
        sb.append(NodeConfigFileName);
        return sb.toString();
    }
}

