/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.network;

import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;

public class Node {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String NodeElement = "node";
    private static final String NameElement = "name";
    private static final String IPElement = "ip_address";
    private static final String PortElement = "port";
    private String name = null;
    private String ipAddress = null;
    private int httpPort = 0;
    private boolean active = true;

    public Node() {
    }

    public Node(String ipAddress, int httpPort) {
        this.ipAddress = ipAddress;
        this.httpPort = httpPort;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setHttpPortString(String strPort) {
        this.httpPort = Integer.valueOf(strPort);
    }

    public void writeTo(XMLTagger xmlTagger) {
        xmlTagger.startElement(NodeElement);
        if (this.name != null) {
            xmlTagger.startElement(NameElement);
            xmlTagger.writeText(this.name);
            xmlTagger.endElement(NameElement);
        }
        if (this.ipAddress != null) {
            xmlTagger.startElement(IPElement);
            xmlTagger.writeText(this.ipAddress);
            xmlTagger.endElement(IPElement);
        }
        if (this.httpPort != 0) {
            xmlTagger.startElement(PortElement);
            xmlTagger.writeText(String.valueOf(this.httpPort));
            xmlTagger.endElement(PortElement);
        }
        xmlTagger.endElement(NodeElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + NodeElement + "/";
        tree.addCallMethod(parentPath + NameElement, "setName");
        tree.addCallMethod(parentPath + PortElement, "setHttpPortString");
        tree.addCallMethod(parentPath + IPElement, "setIpAddress");
    }
}

