/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration.support;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.migration.support.MigrationTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public abstract class CollectionMigrationTask
extends MigrationTask {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String CollectionFileName = "collection.xml";
    protected static final String CollectionCrawlspaceFileName = "collection_crawlspace.xml";
    protected static final String WebCrawlspaceFileName = "web_crawlspace.xml";
    protected static final String FileCrawlspaceFileName = "fs_crawlspace.xml";
    protected static final String ParserConfigFileName = "parser_config.xml";

    public abstract boolean migrate(String var1, String var2, String var3);

    protected boolean insureIndexDescriptorExists(IndexDescriptor.IndexType indexType, CollectionConfiguration collection, CollectionConfiguration defaultCollection, boolean createEmptyLuceneIndex) throws IOException, ExtendedException {
        String indexDirectory;
        File fDirectory;
        boolean modified = false;
        IndexDescriptor descriptor = collection.getIndexDescriptorFor(indexType);
        if (descriptor == null) {
            IndexDescriptor defaultDescriptor = defaultCollection.getIndexDescriptorFor(indexType);
            defaultDescriptor.setCollection(collection);
            collection.getIndexDescriptors().add(defaultDescriptor);
            descriptor = defaultDescriptor;
            modified = true;
        }
        if (!(fDirectory = new File(indexDirectory = descriptor.getAbsolutePath())).exists() && !fDirectory.mkdirs()) {
            Message msg = new Message("M0016E.DIRECTORY_CREATE_FAILED", indexDirectory);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
        if (createEmptyLuceneIndex) {
            FSDirectory directory = null;
            directory = FSDirectory.getDirectory((String)indexDirectory);
            IndexWriter indexWriter = new IndexWriter((Directory)directory, null, true);
            indexWriter.close();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CollectionConfiguration readCollectionConfig(String collectionName, String collectionPath) throws ExtendedException, IOException {
        if (!collectionPath.endsWith(File.separator)) {
            collectionPath = collectionPath + File.separator;
        }
        String fullFileName = collectionPath + CollectionFileName;
        FileInputStream is = null;
        CollectionConfiguration collection = null;
        try {
            is = new FileInputStream(fullFileName);
            collection = CollectionConfiguration.loadFrom(is, null);
            collection.setId(collectionName);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCollectionConfiguration(CollectionConfiguration collection, String collectionPath) throws IOException {
        if (!collectionPath.endsWith(File.separator)) {
            collectionPath = collectionPath + File.separator;
        }
        String fullFileName = collectionPath + CollectionFileName;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(fullFileName);
            collection.writeCollectionComponentTo(os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

