/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.migration.support.SystemMigrationTask;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.util.logging.Level;

public class SpellDirectoryTask_V85
extends SystemMigrationTask {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public boolean migrate(String newVersionId, String configPath) {
        boolean success = true;
        String resourceDirectory = GlobalConfiguration.getConfiguration().getResourcePath();
        File oldSpellDirectory = new File(resourceDirectory, "spell");
        String strNewSpellDirectory = GlobalConfiguration.getConfiguration().getSpellDirectory();
        File newSpellDirectory = new File(strNewSpellDirectory);
        if (oldSpellDirectory.exists()) {
            try {
                FileUtils.copyDirectory(oldSpellDirectory, newSpellDirectory, true);
                FileUtils.removeDirectory(oldSpellDirectory);
            }
            catch (ExtendedException e) {
                success = false;
                Message msg = new Message("M0017E.FILE_MOVE_FAILED", oldSpellDirectory.getAbsolutePath(), newSpellDirectory.getAbsolutePath());
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                this.getLogger().log(Level.SEVERE, ee);
            }
        }
        if (success) {
            Message msg = new Message("M0014I.MIGRATION_FILE_SUCCESSFUL", newSpellDirectory.getAbsolutePath());
            this.getLogger().log(Level.INFO, msg);
        }
        return success;
    }
}

