/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.eventmonitor.Event;
import com.ibm.es.nuvo.eventmonitor.EventManagerData;
import com.ibm.es.nuvo.migration.support.SystemMigrationTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Level;

public class NotificationEventsFileTask_V85
extends SystemMigrationTask {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String NotificationEventsFileName = "notificationEvents.xml";

    public boolean migrate(String newVersionId, String configPath) {
        boolean addMsgSuccess;
        boolean success;
        File notificationEventsFile = new File(configPath, NotificationEventsFileName);
        String logDirectory = GlobalConfiguration.getConfiguration().getLogPath();
        File newNotificationEventsFile = new File(logDirectory, NotificationEventsFileName);
        boolean moveFileSuccess = true;
        if (!newNotificationEventsFile.exists() && notificationEventsFile.exists() && !(moveFileSuccess = notificationEventsFile.renameTo(newNotificationEventsFile))) {
            Message msg = new Message("M0017E.FILE_MOVE_FAILED", notificationEventsFile.getAbsolutePath(), newNotificationEventsFile.getAbsolutePath());
            this.getLogger().log(Level.SEVERE, msg);
        }
        boolean bl = success = (addMsgSuccess = this.addMigrationMsgToFile(newNotificationEventsFile)) && moveFileSuccess;
        if (success) {
            Message msg = new Message("M0014I.MIGRATION_FILE_SUCCESSFUL", newNotificationEventsFile.getAbsolutePath());
            this.getLogger().log(Level.INFO, msg);
        }
        return success;
    }

    private boolean addMigrationMsgToFile(File notificationEventsFile) {
        boolean success = false;
        try {
            EventManagerData data = new EventManagerData();
            try {
                FileInputStream is = new FileInputStream(notificationEventsFile);
                data.loadFrom(is);
                is.close();
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            Message msg = new Message("G0175I.RECRAWL_NEEDED_FOR_MIGRATION");
            Event event = new Event(System.currentTimeMillis(), msg);
            data.getEvents().add(event);
            FileOutputStream os = new FileOutputStream(notificationEventsFile);
            data.writeTo(os);
            os.close();
            success = true;
        }
        catch (Exception e) {
            Message msg = new Message("M0010E.ERROR_MIGRATING_FILE", notificationEventsFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            this.getLogger().log(Level.SEVERE, ee);
        }
        return success;
    }
}

