/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration;

import com.ibm.es.nuvo.Startup;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.migration.Migration;
import com.ibm.es.nuvo.migration.MigrationFrame;
import com.ibm.es.nuvo.migration.MigrationNotificationInterface;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationDriver {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int RETURN_CODE_MIGRATION_SUCCESS = 0;
    private static final int RETURN_CODE_MIGRATION_FAILURE = 1;
    private boolean consoleMode = false;
    private MigrationFrame migrationFrame;

    public static void main(String[] args) {
        MigrationDriver driver = new MigrationDriver();
        int retcode = driver.go(args);
        driver.killGUI();
        System.exit(retcode);
    }

    public void killGUI() {
        if (this.migrationFrame != null) {
            this.migrationFrame.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int go(String[] args) {
        FileChannel lockFileChannel = null;
        FileLock lock = null;
        String globalConfigPath = null;
        globalConfigPath = args.length == 0 ? "config/config.xml" : args[0];
        Vector<String> argVector = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            argVector.add(args[i]);
        }
        if (MigrationDriver.doesArgExist("-?", argVector, true) || MigrationDriver.doesArgExist("?", argVector, true)) {
            MigrationDriver.printUsage();
            return 1;
        }
        if (MigrationDriver.doesArgExist("-console", argVector, true)) {
            this.consoleMode = true;
        } else {
            try {
                this.migrationFrame = new MigrationFrame();
                this.migrationFrame.initializeUI();
                Message startMsg = new Message("M0015I.MIGRATION_PROGRESS", globalConfigPath);
                this.migrationFrame.setLabel(startMsg.getFormattedText());
            }
            catch (Exception e) {
                this.consoleMode = true;
            }
        }
        try {
            File f = new File(globalConfigPath);
            if (!f.exists()) {
                Message msg = new Message("G0045E.GLOBAL_CONFIG_FILE_MISSING", f.getAbsolutePath());
                this.issueMessage(msg.getFormattedTextWithDisplayKey());
                MigrationDriver.printUsage();
                return 1;
            }
            globalConfigPath = f.getAbsolutePath();
            File globalConfigLockFile = new File(globalConfigPath + Startup.globalConfigFileLockExtension);
            lockFileChannel = new RandomAccessFile(globalConfigLockFile, "rw").getChannel();
            try {
                lock = lockFileChannel.tryLock();
                if (lock == null) {
                    Message msg = new Message("M0007E.CONFIG_DIR_LOCKED", globalConfigPath);
                    this.issueMessage(msg.getFormattedTextWithDisplayKey());
                    return 1;
                }
                globalConfigLockFile.deleteOnExit();
            }
            catch (OverlappingFileLockException e) {
                Message msg = new Message("M0007E.CONFIG_DIR_LOCKED", globalConfigPath);
                this.issueMessage(msg.getFormattedTextWithDisplayKey());
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        Migration migration = this.buildMigration();
        MigrationNotification callback = new MigrationNotification();
        if (this.consoleMode) {
            callback.printScale();
        }
        boolean success = false;
        ExtendedException initializeError = null;
        try {
            success = migration.doMigration("newLevel", globalConfigPath, callback);
        }
        catch (ExtendedException e) {
            initializeError = e;
        }
        catch (Throwable t) {
            Message msg = new Message("M0004E.UNEXPECTED_ERROR_MIGRATION_TASK");
            this.issueMessage(msg.getFormattedTextWithDisplayKey());
            if (this.consoleMode) {
                System.out.println(t.getStackTrace());
            }
        }
        finally {
            try {
                lock.release();
                lockFileChannel.close();
                lock = null;
                lockFileChannel = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        callback.finishStatus();
        Message msg = null;
        if (success) {
            msg = new Message("M0002I.MIGRATION_END_SUCCESS");
            if (!this.consoleMode) {
                this.migrationFrame.setLabel(msg.getFormattedTextWithDisplayKey());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {}
            } else {
                System.out.println(msg.getFormattedTextWithDisplayKey());
            }
            return 0;
        }
        String logFileName = migration.getLogFileName();
        if (initializeError == null) {
            msg = new Message("M0011E.MIGRATION_END_ERROR_WITH_MIGRATION_FILE_NAME", logFileName);
        } else {
            ArrayList<Message> msgList = initializeError.getChainedMessages();
            for (int i = 0; i < msgList.size(); ++i) {
                this.issueMessage(((Message)msgList.get(i)).getFormattedTextWithDisplayKey());
            }
            msg = new Message("M0008E.MIGRATION_ERROR_STARTING", globalConfigPath, logFileName);
        }
        this.issueMessage(msg.getFormattedTextWithDisplayKey());
        return 1;
    }

    private static int getArgIndex(String argName, Vector<String> argVector) {
        int foundAt = -1;
        for (int i = 0; i < argVector.size() && foundAt < 0; ++i) {
            if (!argName.equalsIgnoreCase(argVector.get(i))) continue;
            foundAt = i;
        }
        return foundAt;
    }

    private static boolean doesArgExist(String argName, Vector<String> argVector, boolean removeFromList) {
        boolean exist;
        int argIndex = MigrationDriver.getArgIndex(argName, argVector);
        boolean bl = exist = argIndex >= 0;
        if (removeFromList && exist) {
            argVector.removeElementAt(argIndex);
        }
        return exist;
    }

    private static void printUsage() {
        Locale currentLocale = Locale.getDefault();
        String textBase = "M0006I.CMDLINE_HELP";
        String text = Message.getText(textBase, currentLocale);
        System.out.println(text);
    }

    protected Migration buildMigration() {
        return new Migration();
    }

    private void issueMessage(String message) {
        if (this.consoleMode) {
            System.out.println(message);
        } else {
            this.migrationFrame.showError(message);
        }
    }

    class MigrationNotification
    implements MigrationNotificationInterface {
        private int totalNumDots = 40;
        private int totalNumSteps = 0;
        private int dotsPrinted = 0;
        private int stepsCompleted = 0;

        MigrationNotification() {
        }

        public void totalNumberOfSteps(int numSteps) {
            this.totalNumSteps = numSteps;
            if (!MigrationDriver.this.consoleMode) {
                MigrationDriver.this.migrationFrame.setTotalSteps(numSteps);
            }
        }

        public void stepCompleted() {
            ++this.stepsCompleted;
            if (MigrationDriver.this.consoleMode) {
                this.printDots();
            } else {
                MigrationDriver.this.migrationFrame.updateStatus(this.stepsCompleted);
            }
        }

        public void finishStatus() {
            this.stepsCompleted = this.totalNumSteps;
            if (MigrationDriver.this.consoleMode) {
                this.printDots();
                System.out.println("");
            } else {
                MigrationDriver.this.migrationFrame.updateStatus(this.totalNumSteps);
            }
        }

        private void printDots() {
            double pctDone = (double)this.stepsCompleted / (double)this.totalNumSteps;
            int numDotsNeeded = (int)((double)this.totalNumDots * pctDone);
            if (numDotsNeeded > this.totalNumDots) {
                numDotsNeeded = this.totalNumDots;
            }
            for (int i = this.dotsPrinted; i < numDotsNeeded; ++i) {
                System.out.print(".");
                ++this.dotsPrinted;
            }
        }

        public void printScale() {
            System.out.println("");
            System.out.println("0.................50%...............100%");
        }
    }
}

