/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.LoggerWrapper;
import com.ibm.es.nuvo.migration.CollectionFileTask_V85;
import com.ibm.es.nuvo.migration.FileCrawlspaceFileTask_V85;
import com.ibm.es.nuvo.migration.MigrationNotificationInterface;
import com.ibm.es.nuvo.migration.NotificationEventsFileTask_V85;
import com.ibm.es.nuvo.migration.SpellDirectoryTask_V85;
import com.ibm.es.nuvo.migration.support.CollectionMigrationTask;
import com.ibm.es.nuvo.migration.support.SystemMigrationTask;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Migration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String DefaultLogFilePrefix = "migration";
    private static final String DefaultLoggerName = "com.ibm.es.nuvo.migration.MigrationLogger";
    private String logFileName = null;

    public String getLogFileName() {
        return this.logFileName;
    }

    public boolean doMigration(String newLevel, String globalConfigFilePath, MigrationNotificationInterface notificationInterface) throws ExtendedException {
        int i;
        boolean success = true;
        GlobalConfiguration globalConfig = null;
        try {
            GlobalConfiguration.initialize(globalConfigFilePath);
            ReleaseInfo.initialize(null);
            globalConfig = GlobalConfiguration.getConfiguration();
        }
        catch (Exception e) {
            Message msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(globalConfigFilePath);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        String logFilePath = globalConfig.getLogPath();
        if (!logFilePath.endsWith(File.separator)) {
            logFilePath = logFilePath + File.separator;
        }
        ExtendedLogger logger = ExtendedLogger.getLogger(DefaultLoggerName);
        LoggerWrapper loggerWrapper = new LoggerWrapper(logger, logFilePath, DefaultLogFilePrefix);
        loggerWrapper.initialize();
        File[] logFiles = loggerWrapper.getLogFiles();
        if (logFiles != null && logFiles.length > 0) {
            this.logFileName = logFiles[0].getAbsolutePath();
        }
        Message startMsg = new Message("M0001I.MIGRATION_START", globalConfigFilePath);
        logger.log(Level.INFO, startMsg);
        Vector<SystemMigrationTask> systemTaskList = this.buildSystemTaskList();
        Vector<CollectionMigrationTask> collectionTaskList = this.buildCollectionTaskList();
        String collectionPathName = GlobalConfiguration.getConfiguration().getCollectionPath();
        File file = new File(collectionPathName);
        File[] collectionDirectories = file.listFiles();
        if (notificationInterface != null) {
            int totalSteps = 0;
            for (i = 0; i < systemTaskList.size(); ++i) {
                totalSteps += systemTaskList.get(i).getNumberOfSteps();
            }
            int collectionSteps = 0;
            for (int i2 = 0; i2 < collectionTaskList.size(); ++i2) {
                collectionSteps += collectionTaskList.get(i2).getNumberOfSteps();
            }
            if (collectionDirectories != null) {
                totalSteps += collectionSteps * collectionDirectories.length;
            }
            notificationInterface.totalNumberOfSteps(totalSteps);
        }
        String configDirectory = GlobalConfiguration.getConfiguration().getConfigPath();
        for (i = 0; i < systemTaskList.size(); ++i) {
            SystemMigrationTask task = systemTaskList.get(i);
            task.setLogger(logger);
            task.setNotification(notificationInterface);
            boolean taskSuccess = false;
            try {
                taskSuccess = task.migrate(newLevel, configDirectory);
            }
            catch (Throwable e) {
                Message msg = new Message("M0004E.UNEXPECTED_ERROR_MIGRATION_TASK");
                ExtendedException ee = new ExtendedException(msg, e);
                logger.log(Level.SEVERE, ee);
            }
            boolean bl = success = success && taskSuccess;
            if (task.isNotificationSent()) continue;
            task.notifyStepFinished();
        }
        if (collectionDirectories != null) {
            for (i = 0; i < collectionDirectories.length; ++i) {
                for (int j = 0; j < collectionTaskList.size(); ++j) {
                    CollectionMigrationTask task = collectionTaskList.get(j);
                    task.setLogger(logger);
                    task.setNotification(notificationInterface);
                    boolean taskSuccess = false;
                    try {
                        taskSuccess = task.migrate(newLevel, collectionDirectories[i].getName(), collectionDirectories[i].getAbsolutePath());
                    }
                    catch (Throwable e) {
                        Message msg = new Message("M0004E.UNEXPECTED_ERROR_MIGRATION_TASK");
                        ExtendedException ee = new ExtendedException(msg, e);
                        logger.log(Level.SEVERE, ee);
                    }
                    boolean bl = success = success && taskSuccess;
                    if (task.isNotificationSent()) continue;
                    task.notifyStepFinished();
                }
            }
        }
        if (success) {
            Message endMsg = new Message("M0002I.MIGRATION_END_SUCCESS");
            logger.log(Level.INFO, endMsg);
        } else {
            Message endMsg = new Message("M0012E.MIGRATION_END_ERROR");
            logger.log(Level.SEVERE, endMsg);
        }
        loggerWrapper.flush();
        loggerWrapper.close();
        return success;
    }

    protected Vector<CollectionMigrationTask> buildCollectionTaskList() {
        Vector<CollectionMigrationTask> tasks = new Vector<CollectionMigrationTask>();
        tasks.add(new CollectionFileTask_V85());
        tasks.add(new FileCrawlspaceFileTask_V85());
        return tasks;
    }

    protected Vector<SystemMigrationTask> buildSystemTaskList() {
        Vector<SystemMigrationTask> tasks = new Vector<SystemMigrationTask>();
        tasks.add(new NotificationEventsFileTask_V85());
        tasks.add(new SpellDirectoryTask_V85());
        return tasks;
    }
}

