/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.util.migration.FSCrawlerConfigMigration;
import com.ibm.es.nuvo.migration.support.CollectionMigrationTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;

public class FileCrawlspaceFileTask_V85
extends CollectionMigrationTask {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String fullFileName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrate(String newVersionId, String collectionName, String collectionPath) {
        boolean success = true;
        if (!collectionPath.endsWith(File.separator)) {
            collectionPath = collectionPath + File.separator;
        }
        this.fullFileName = collectionPath + "fs_crawlspace.xml";
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.fullFileName);
            FSCrawlerConfigMigration fsMigration = new FSCrawlerConfigMigration();
            fsMigration.migrateFileCrawlerData(is, collectionPath);
            Message msg = new Message("M0014I.MIGRATION_FILE_SUCCESSFUL", this.fullFileName);
            this.getLogger().log(Level.INFO, msg);
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            success = false;
            Message msg = new Message("M0010E.ERROR_MIGRATING_FILE", this.fullFileName);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            this.getLogger().log(Level.SEVERE, ee);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return success;
    }
}

