/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.migration;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.migration.support.CollectionMigrationTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;

public class CollectionFileTask_V85
extends CollectionMigrationTask {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected CollectionConfiguration defaultCollection = null;
    protected String fullFileName = null;

    public boolean migrate(String newVersionId, String collectionName, String collectionPath) {
        boolean success = true;
        ExtendedLogger logger = this.getLogger();
        if (!collectionPath.endsWith(File.separator)) {
            collectionPath = collectionPath + File.separator;
        }
        this.fullFileName = collectionPath + "collection.xml";
        try {
            CollectionConfiguration collection;
            boolean dataModified;
            if (this.defaultCollection == null) {
                this.defaultCollection = CollectionConfiguration.createDefault();
            }
            if (dataModified = this.doMigration(collection = this.readCollectionConfig(collectionName, collectionPath))) {
                this.writeCollectionConfiguration(collection, collectionPath);
            }
            Message msg = new Message("M0014I.MIGRATION_FILE_SUCCESSFUL", this.fullFileName);
            logger.log(Level.INFO, msg);
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            success = false;
            Message msg = new Message("M0010E.ERROR_MIGRATING_FILE", this.fullFileName);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            logger.log(Level.SEVERE, ee);
        }
        return success;
    }

    protected boolean doMigration(CollectionConfiguration collection) throws IOException, ExtendedException {
        boolean crawlAdded;
        boolean modified = false;
        boolean facetAdded = this.insureIndexDescriptorExists(IndexDescriptor.IndexType.Facet, collection, this.defaultCollection, false);
        if (facetAdded) {
            Message msg = new Message("M0009I.MIGRATION_ITEM_OK", new Object[]{IndexDescriptor.IndexType.Facet, this.fullFileName});
            this.getLogger().log(Level.INFO, msg);
            modified = true;
        }
        if (crawlAdded = this.insureIndexDescriptorExists(IndexDescriptor.IndexType.Crawl, collection, this.defaultCollection, true)) {
            Message msg = new Message("M0009I.MIGRATION_ITEM_OK", new Object[]{IndexDescriptor.IndexType.Crawl, this.fullFileName});
            this.getLogger().log(Level.INFO, msg);
            modified = true;
        }
        return modified;
    }
}

