/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.util;

import com.ibm.es.nuvo.util.Vint8;
import java.io.IOException;
import org.apache.lucene.index.TermPositions;

public class MarkupPayload {
    public static final int MP_NOT_VALID = -1;
    private int tagSerialNumber;
    private int tokenLength;
    private int depth = -1;
    private int numDescendants;
    private byte[] payloadBytes;
    private static final int MP_MAX_BYTES_NEEDED = 20;

    public void loadFromTermPositions(TermPositions termPositions) throws IOException {
        if (this.payloadBytes == null) {
            this.payloadBytes = new byte[20];
        }
        termPositions.getPayload(this.payloadBytes, 0);
        int payloadLength = termPositions.getPayloadLength();
        Vint8.Position pos = new Vint8.Position();
        this.tagSerialNumber = Vint8.decode(this.payloadBytes, pos);
        this.tokenLength = Vint8.decode(this.payloadBytes, pos);
        this.depth = payloadLength > pos.pos ? Vint8.decode(this.payloadBytes, pos) : -1;
        this.numDescendants = payloadLength > pos.pos ? Vint8.decode(this.payloadBytes, pos) : 0;
    }

    public static byte[] newPayload(int tagSerialNumber, int tokenLength) {
        int bytesNeeded = Vint8.bytesNeeded(tagSerialNumber) + Vint8.bytesNeeded(tokenLength);
        byte[] payload = new byte[bytesNeeded];
        int start = Vint8.encode(tagSerialNumber, payload, 0);
        Vint8.encode(tokenLength, payload, start);
        return payload;
    }

    public static byte[] newPayload(int tagSerialNumber, int tokenLength, int depth, int numDescendants) {
        int bytesNeeded = Vint8.bytesNeeded(tagSerialNumber) + Vint8.bytesNeeded(tokenLength) + Vint8.bytesNeeded(depth);
        if (numDescendants > 0) {
            bytesNeeded += Vint8.bytesNeeded(numDescendants);
        }
        byte[] payload = new byte[bytesNeeded];
        int start = Vint8.encode(tagSerialNumber, payload, 0);
        start += Vint8.encode(tokenLength, payload, start);
        start += Vint8.encode(depth, payload, start);
        if (numDescendants > 0) {
            Vint8.encode(numDescendants, payload, start);
        }
        return payload;
    }

    public int getTagSerialNumber() {
        return this.tagSerialNumber;
    }

    public int getNumberOfDescendants() {
        return this.numDescendants;
    }

    public int getNumberOfTokensSpanned() {
        return this.tokenLength;
    }

    public int getTagDepth() {
        return this.depth;
    }
}

