/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.targetelement;

import com.ibm.es.nuvo.markup.query.MarkupContainsQuery;
import com.ibm.es.nuvo.markup.query.MarkupQueryException;
import com.ibm.es.nuvo.markup.search.MarkupScorer;
import com.ibm.es.nuvo.markup.search.targetelement.TargetElementHitQueue;
import com.ibm.es.nuvo.markup.search.targetelement.TargetElementScoreDoc;
import com.ibm.es.nuvo.markup.search.targetelement.TargetElementTopDocs;
import com.ibm.es.nuvo.markup.util.IntArrayUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.PriorityQueue;

public class TargetElementCollector
extends HitCollector {
    private int numHits;
    private float minScore = 0.0f;
    private int totalHits;
    private PriorityQueue hq;
    private ArrayList markupScorers;
    private boolean hasTargetElements = false;
    private boolean hasScorers = false;
    private HashMap docElements;
    private boolean collectionFailed = false;
    private IOException failException = null;

    public TargetElementCollector(Query query, int numHits_) throws MarkupQueryException {
        this.numHits = numHits_;
        this.hq = new TargetElementHitQueue(numHits_);
        this.markupScorers = new ArrayList();
        this.docElements = new HashMap();
        this.hasTargetElements = this.assignMarkupContainsQueries(query);
    }

    private boolean findMarkupContainsQueries(Query query, LinkedList queryList) throws MarkupQueryException {
        if (query instanceof MarkupContainsQuery) {
            MarkupContainsQuery markupContainsQuery = (MarkupContainsQuery)query;
            if (markupContainsQuery.hasTargetElements()) {
                queryList.add(query);
                return true;
            }
        } else if (query instanceof BooleanQuery) {
            boolean hasTargetElements = false;
            BooleanClause[] clauses = ((BooleanQuery)query).getClauses();
            for (int i = 0; i < clauses.length; ++i) {
                if (!this.findMarkupContainsQueries(clauses[i].getQuery(), queryList)) continue;
                hasTargetElements = true;
            }
            return hasTargetElements;
        }
        return false;
    }

    private boolean assignMarkupContainsQueries(Query query) throws MarkupQueryException {
        LinkedList queryList = new LinkedList();
        if (!this.findMarkupContainsQueries(query, queryList)) {
            return false;
        }
        MarkupContainsQuery lastQuery = (MarkupContainsQuery)queryList.getLast();
        for (MarkupContainsQuery currQuery : queryList) {
            currQuery.setTargetElementHandlerAndRoot(lastQuery, query);
        }
        try {
            lastQuery.setTargetElementCollector(this);
        }
        catch (InterruptedException e) {
            throw new MarkupQueryException(e);
        }
        return true;
    }

    public void collect(int doc, float score) {
        if (score > 0.0f && !this.collectionFailed) {
            ++this.totalHits;
            if (this.hq.size() < this.numHits) {
                this.addToQueue(doc, score);
            } else if (score >= this.minScore) {
                if (this.hasScorers) {
                    ScoreDoc toRemove = (ScoreDoc)this.hq.pop();
                    this.docElements.remove(toRemove);
                }
                this.addToQueue(doc, score);
            }
        }
    }

    private void addToQueue(int doc, float score) {
        ScoreDoc toAdd = new ScoreDoc(doc, score);
        this.hq.insert((Object)toAdd);
        this.minScore = ((ScoreDoc)this.hq.top()).score;
        if (this.hasScorers) {
            int[] elements;
            block6: {
                elements = null;
                try {
                    if (this.markupScorers.size() == 1) {
                        MarkupScorer scorer = (MarkupScorer)((Object)this.markupScorers.get(0));
                        if (scorer.doc() == doc) {
                            elements = scorer.getElements();
                        }
                    } else {
                        elements = this.getElementsMultipleScorers(doc);
                    }
                }
                catch (IOException e) {
                    elements = null;
                    this.collectionFailed = true;
                    if (this.failException != null) break block6;
                    this.failException = e;
                }
            }
            this.docElements.put(toAdd, elements);
        }
    }

    private int[] getElementsMultipleScorers(int doc) throws IOException {
        ListIterator itScorers = this.markupScorers.listIterator();
        ArrayList<int[]> elementArrays = new ArrayList<int[]>();
        int totalElements = 0;
        while (itScorers.hasNext()) {
            int[] temp;
            MarkupScorer scorer = (MarkupScorer)((Object)itScorers.next());
            if (scorer.doc() != doc || (temp = scorer.getElements()).length <= 0) continue;
            elementArrays.add(temp);
            totalElements += temp.length;
        }
        if (totalElements == 0) {
            return null;
        }
        int[] elements = new int[totalElements];
        int offset = 0;
        ListIterator itArrays = elementArrays.listIterator();
        while (itArrays.hasNext()) {
            int[] temp = (int[])itArrays.next();
            System.arraycopy(temp, 0, elements, offset, temp.length);
            offset += temp.length;
        }
        Arrays.sort(elements);
        elements = IntArrayUtils.removeDuplicates(elements);
        return elements;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TargetElementTopDocs targetElementTopDocs() throws IOException {
        if (this.collectionFailed) {
            throw this.failException;
        }
        TargetElementScoreDoc[] scoreDocs = new TargetElementScoreDoc[this.hq.size()];
        for (int i = this.hq.size() - 1; i >= 0; --i) {
            ScoreDoc scoreDoc = (ScoreDoc)this.hq.pop();
            int[] elements = (int[])this.docElements.get(scoreDoc);
            scoreDocs[i] = new TargetElementScoreDoc(scoreDoc.doc, scoreDoc.score, elements);
        }
        float maxScore = this.totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        this.markupScorers.clear();
        this.docElements.clear();
        return new TargetElementTopDocs(this.totalHits, scoreDocs, maxScore);
    }

    public void addMarkupScorer(MarkupScorer markupScorer) {
        this.markupScorers.add(markupScorer);
        this.hasScorers = true;
    }

    public boolean hasTargetElements() {
        return this.hasTargetElements;
    }
}

