/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.spans;

import com.ibm.es.nuvo.markup.util.MarkupPayload;
import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.spans.Spans;

public class TagSpans
implements Spans {
    public static final int TS_NOT_A_DOCUMENT = -1;
    private TermPositions positions = null;
    private int doc = -1;
    private int freq;
    private int count;
    private int position;
    private int payloadId = -1;
    private int payloadEnd = -1;
    private int payloadIdLast = -1;
    private int payloadDepth = -1;
    private MarkupPayload markupPayload = new MarkupPayload();
    private boolean payloadFieldsNeedUpdating = true;

    public TagSpans(TermPositions positions_) {
        this.positions = positions_;
    }

    public boolean next() throws IOException {
        if (this.count == this.freq) {
            if (!this.positions.next()) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
            this.doc = this.positions.doc();
            this.freq = this.positions.freq();
            this.count = 0;
        }
        this.position = this.positions.nextPosition();
        ++this.count;
        this.payloadFieldsNeedUpdating = true;
        return true;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.doc >= target) {
            return true;
        }
        if (!this.positions.skipTo(target)) {
            this.doc = Integer.MAX_VALUE;
            return false;
        }
        this.doc = this.positions.doc();
        this.freq = this.positions.freq();
        this.count = 0;
        this.position = this.positions.nextPosition();
        ++this.count;
        this.payloadFieldsNeedUpdating = true;
        return true;
    }

    public int doc() {
        return this.doc;
    }

    public int start() {
        return this.position;
    }

    public int end() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadEnd;
    }

    public int id() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadId;
    }

    public int idLast() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadIdLast;
    }

    public int depth() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadDepth;
    }

    public String toString() {
        return "tagSpans@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + "(" + this.start() + "," + this.end() + ")[" + this.id() + "," + this.idLast() + "]" + this.depth()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePayloadFields() {
        try {
            this.markupPayload.loadFromTermPositions(this.positions);
            this.payloadId = this.markupPayload.getTagSerialNumber();
            this.payloadEnd = this.position + this.markupPayload.getNumberOfTokensSpanned();
            this.payloadIdLast = this.payloadId + this.markupPayload.getNumberOfDescendants();
            this.payloadDepth = this.markupPayload.getTagDepth();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.payloadId = -1;
            this.payloadEnd = -1;
            this.payloadIdLast = -1;
            this.payloadDepth = -1;
        }
        finally {
            this.payloadFieldsNeedUpdating = false;
        }
    }
}

