/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.spans;

import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import com.ibm.es.nuvo.util.decimal.DecimalTermPositions;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanNumericQuery
extends SpanTermQuery {
    private DecimalCondition condition;
    private static final long serialVersionUID = 1L;

    public SpanNumericQuery(String attributeName, DecimalCondition cond) {
        super(new Term("_numvals", attributeName));
        this.condition = cond;
    }

    public boolean equals(Object o) {
        if (o instanceof SpanNumericQuery) {
            SpanNumericQuery q = (SpanNumericQuery)((Object)o);
            return this.term.field().equals(q.term.field()) && this.condition.equals(q.condition);
        }
        return false;
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        DecimalTermPositions termPos = new DecimalTermPositions(reader, this.getTerm(), this.condition);
        return new SNQSpans(termPos);
    }

    private class SNQSpans
    implements Spans {
        private DecimalTermPositions decimalPositions;
        private int freq;
        private int count;
        private int pos;

        public SNQSpans(DecimalTermPositions termPos) {
            this.decimalPositions = termPos;
        }

        public int doc() {
            return this.decimalPositions.doc();
        }

        public int end() {
            return this.pos;
        }

        public boolean next() throws IOException {
            if (this.count >= this.freq) {
                if (!this.decimalPositions.next()) {
                    return false;
                }
                this.count = 0;
                this.freq = this.decimalPositions.freq();
            }
            ++this.count;
            this.pos = this.decimalPositions.nextPosition();
            return true;
        }

        public boolean skipTo(int target) throws IOException {
            return this.decimalPositions.skipTo(target);
        }

        public int start() {
            return this.pos;
        }
    }
}

