/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanMultiTermQuery
extends SpanQuery {
    private static final long serialVersionUID = -3333486873583953280L;
    private Query query;
    private int type;
    private static int TYPE_MULTI_TERM = 0;
    private static int TYPE_PREFIX = 1;
    private static int TYPE_RANGE = 2;

    public SpanMultiTermQuery(Query query_) throws IOException {
        if (query_ instanceof MultiTermQuery) {
            this.type = TYPE_MULTI_TERM;
        } else if (query_ instanceof PrefixQuery) {
            this.type = TYPE_PREFIX;
        } else if (query_ instanceof RangeQuery) {
            this.type = TYPE_RANGE;
        } else {
            throw new IOException("SpanMultiTermQuery does not support queries of type " + query_.getClass().getName());
        }
        this.query = query_;
    }

    public String getField() {
        if (this.type == TYPE_RANGE) {
            RangeQuery rangeQuery = (RangeQuery)this.query;
            return rangeQuery.getField();
        }
        return this.getTerm().field();
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        BooleanQuery booleanQuery = (BooleanQuery)this.query.rewrite(reader);
        BooleanClause[] booleanClauses = booleanQuery.getClauses();
        SpanTermQuery[] termQueries = new SpanTermQuery[booleanClauses.length];
        for (int i = 0; i < booleanClauses.length; ++i) {
            TermQuery query_ = (TermQuery)booleanClauses[i].getQuery();
            termQueries[i] = new SpanTermQuery(query_.getTerm());
            termQueries[i].setBoost(query_.getBoost());
        }
        SpanOrQuery orQuery = new SpanOrQuery((SpanQuery[])termQueries);
        return orQuery.getSpans(reader);
    }

    public void extractTerms(IndexReader reader, Set terms) throws IOException {
        BooleanQuery booleanQuery = (BooleanQuery)this.query.rewrite(reader);
        BooleanClause[] booleanClauses = booleanQuery.getClauses();
        for (int i = 0; i < booleanClauses.length; ++i) {
            TermQuery query_ = (TermQuery)booleanClauses[i].getQuery();
            terms.add(query_.getTerm());
        }
    }

    public void extractTerms(Set terms) {
        terms.add(this.getTerm());
    }

    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.getTerm());
        return terms;
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    private Term getTerm() {
        if (this.type == TYPE_MULTI_TERM) {
            MultiTermQuery multi = (MultiTermQuery)this.query;
            return multi.getTerm();
        }
        if (this.type == TYPE_PREFIX) {
            PrefixQuery prefix = (PrefixQuery)this.query;
            return prefix.getPrefix();
        }
        if (this.type == TYPE_RANGE) {
            RangeQuery range = (RangeQuery)this.query;
            return range.getLowerTerm();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof SpanMultiTermQuery) {
            SpanMultiTermQuery other = (SpanMultiTermQuery)((Object)o);
            return this.query.equals(other.query);
        }
        return false;
    }
}

