/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanMultiPhraseQuery
extends SpanQuery {
    private MultiPhraseQuery multiPhraseQuery;
    private String fieldName;
    private static final long serialVersionUID = 1L;

    public SpanMultiPhraseQuery(MultiPhraseQuery multiPhraseQuery) {
        this.multiPhraseQuery = multiPhraseQuery;
    }

    public void extractTerms(Set set) {
        this.multiPhraseQuery.extractTerms(set);
    }

    public String getField() {
        if (this.fieldName == null) {
            List termArrays = this.multiPhraseQuery.getTermArrays();
            Term[] termArray = (Term[])termArrays.get(0);
            this.fieldName = termArray[0].field();
        }
        return this.fieldName;
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        return new SpansImpl(reader);
    }

    public Collection getTerms() {
        HashSet terms = new HashSet();
        this.multiPhraseQuery.extractTerms(terms);
        return terms;
    }

    public String toString(String field) {
        return this.multiPhraseQuery.toString(field);
    }

    public Query getQuery() {
        return this.multiPhraseQuery;
    }

    private class TargetChangedException
    extends IOException {
        int newTarget;
        public static final long serialVersionUID = 1L;

        public TargetChangedException(int newTarget) {
            this.newTarget = newTarget;
        }
    }

    private class NoMatchException
    extends IOException {
        public static final long serialVersionUID = 1L;

        private NoMatchException() {
        }
    }

    private class TermPositionIterator {
        private TermPositions termPositions;
        int doc = -1;
        int position;
        private int freq;
        private int count;

        public TermPositionIterator(TermPositions termPositions) {
            this.termPositions = termPositions;
        }

        public boolean next() throws IOException {
            if (this.count == this.freq) {
                if (!this.termPositions.next()) {
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
                this.doc = this.termPositions.doc();
                this.freq = this.termPositions.freq();
                this.count = 0;
            }
            this.position = this.termPositions.nextPosition();
            ++this.count;
            return true;
        }

        public boolean skipTo(int target) throws IOException {
            if (this.doc >= target) {
                return this.doc != Integer.MAX_VALUE;
            }
            if (!this.termPositions.skipTo(target)) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
            this.doc = this.termPositions.doc();
            this.freq = this.termPositions.freq();
            this.position = this.termPositions.nextPosition();
            this.count = 1;
            return true;
        }
    }

    private class TermGroupIterator {
        private Term[] terms;
        private TermPositionIterator[] tpIterators;
        int doc = -1;
        int position;

        public TermGroupIterator(Term[] terms, IndexReader reader) throws IOException {
            if (terms == null) {
                throw new IllegalArgumentException("null term group");
            }
            this.terms = terms;
            this.tpIterators = new TermPositionIterator[terms.length];
            for (int j = 0; j < this.terms.length; ++j) {
                this.tpIterators[j] = new TermPositionIterator(reader.termPositions(this.terms[j]));
            }
        }

        public boolean skipTo(int target) throws IOException {
            if (this.doc >= target) {
                if (this.doc == Integer.MAX_VALUE) {
                    throw new NoMatchException();
                }
                return true;
            }
            for (int j = 0; j < this.tpIterators.length; ++j) {
                if (this.tpIterators[j].doc >= target) continue;
                this.tpIterators[j].skipTo(target);
            }
            this.chooseFirstMatch(target);
            return true;
        }

        public boolean next() throws IOException {
            if (this.doc == Integer.MAX_VALUE) {
                throw new NoMatchException();
            }
            for (int j = 0; j < this.tpIterators.length; ++j) {
                TermPositionIterator tpi = this.tpIterators[j];
                if (tpi.doc != this.doc || tpi.position != this.position) continue;
                tpi.next();
            }
            this.chooseFirstMatch(this.doc);
            return true;
        }

        private void chooseFirstMatch(int target) throws IOException {
            int minIndex = Integer.MAX_VALUE;
            int minDoc = Integer.MAX_VALUE;
            int minPos = Integer.MAX_VALUE;
            for (int j = 0; j < this.tpIterators.length; ++j) {
                TermPositionIterator tpi = this.tpIterators[j];
                if (tpi.doc < minDoc) {
                    minDoc = tpi.doc;
                    minPos = tpi.position;
                    minIndex = j;
                    continue;
                }
                if (tpi.doc != minDoc || tpi.position >= minPos) continue;
                minPos = tpi.position;
                minIndex = j;
            }
            if (minIndex == Integer.MAX_VALUE) {
                throw new NoMatchException();
            }
            this.doc = minDoc;
            this.position = minPos;
            if (this.doc != target && target != -1) {
                throw new TargetChangedException(this.doc);
            }
        }
    }

    private class SpansImpl
    implements Spans {
        private TermGroupIterator[] tgIterators;
        protected int[] termArrayDeltas;
        private int doc = -1;
        private int start;
        private int end;

        public SpansImpl(IndexReader reader) throws IOException {
            List termArrays = SpanMultiPhraseQuery.this.multiPhraseQuery.getTermArrays();
            this.tgIterators = new TermGroupIterator[termArrays.size()];
            int counter = 0;
            for (Term[] terms : termArrays) {
                this.tgIterators[counter++] = new TermGroupIterator(terms, reader);
            }
            int[] termArrayPositions = SpanMultiPhraseQuery.this.multiPhraseQuery.getPositions();
            this.termArrayDeltas = new int[termArrayPositions.length - 1];
            for (int j = 1; j < termArrayPositions.length; ++j) {
                this.termArrayDeltas[j - 1] = termArrayPositions[j] - termArrayPositions[j - 1];
            }
        }

        public int doc() {
            return this.doc;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public boolean next() throws IOException {
            if (this.doc == Integer.MAX_VALUE) {
                return false;
            }
            try {
                int maxDoc = Integer.MIN_VALUE;
                for (int j = 0; j < this.tgIterators.length; ++j) {
                    try {
                        this.tgIterators[j].next();
                        continue;
                    }
                    catch (TargetChangedException e) {
                        if (e.newTarget <= maxDoc) continue;
                        maxDoc = e.newTarget;
                    }
                }
                return this.align(maxDoc);
            }
            catch (NoMatchException e) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
        }

        public boolean skipTo(int targetDoc) throws IOException {
            if (this.doc >= targetDoc) {
                return this.doc != Integer.MAX_VALUE;
            }
            return this.align(targetDoc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean align(int targetDoc) throws IOException {
            try {
                int numRightDoc = 0;
                while (true) {
                    try {
                        while (numRightDoc < this.tgIterators.length) {
                            for (int j = 0; j < this.tgIterators.length; ++j) {
                                TermGroupIterator tgi = this.tgIterators[j];
                                tgi.skipTo(targetDoc);
                                ++numRightDoc;
                            }
                        }
                        int firstPos = this.tgIterators[0].position;
                        int currPos = 0;
                        int prevPos = firstPos;
                        int numRightPos = 1;
                        while (numRightPos < this.tgIterators.length) {
                            for (int j = 1; j < this.tgIterators.length; ++j) {
                                TermGroupIterator tgi = this.tgIterators[j];
                                currPos = tgi.position;
                                int deltaDiff = currPos - prevPos - this.termArrayDeltas[j - 1];
                                while (deltaDiff != 0) {
                                    try {
                                        if (deltaDiff > 0) {
                                            tgi = this.tgIterators[0];
                                            throw new TargetChangedException(tgi.doc);
                                        }
                                    }
                                    finally {
                                        tgi.next();
                                        currPos = tgi.position;
                                    }
                                    deltaDiff = currPos - prevPos - this.termArrayDeltas[j - 1];
                                }
                                ++numRightPos;
                                prevPos = currPos;
                            }
                        }
                        this.doc = targetDoc;
                        this.start = firstPos;
                        this.end = currPos + 1;
                        return true;
                    }
                    catch (TargetChangedException e) {
                        targetDoc = e.newTarget;
                        numRightDoc = 0;
                        continue;
                    }
                    break;
                }
            }
            catch (NoMatchException e) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
        }
    }
}

