/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.spans;

import com.ibm.es.nuvo.markup.search.spans.SpanTagQuery;
import com.ibm.es.nuvo.markup.search.spans.TagSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public abstract class SpanCompoundTagQuery
extends SpanQuery {
    Term[] terms = null;
    private static final long serialVersionUID = 2821318905178326138L;

    public SpanCompoundTagQuery(String[] tagNames) throws IOException {
        if (tagNames == null || tagNames.length == 0) {
            throw new IOException("No tag names given for intersection");
        }
        this.terms = new Term[tagNames.length];
        for (int i = 0; i < tagNames.length; ++i) {
            this.terms[i] = new Term("_xmltags", tagNames[i]);
        }
    }

    public String getField() {
        for (int i = 1; i < this.terms.length; ++i) {
            if (this.terms[i].field().equals("_xmltags")) continue;
            return null;
        }
        return "_xmltags";
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        if (this.terms.length == 1) {
            return new TagSpans(reader.termPositions(this.terms[0]));
        }
        SpanTagQuery[] tagQueries = new SpanTagQuery[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            tagQueries[i] = new SpanTagQuery(this.terms[i].text(), false);
        }
        return this.getSpans(tagQueries, reader);
    }

    protected abstract Spans getSpans(SpanTagQuery[] var1, IndexReader var2) throws IOException;

    public Collection getTerms() {
        ArrayList<Term> termsList = new ArrayList<Term>();
        for (int i = 0; i < this.terms.length; ++i) {
            termsList.add(this.terms[i]);
        }
        return termsList;
    }

    public void extractTerms(Set terms_) {
        for (int i = 0; i < this.terms.length; ++i) {
            terms_.add(this.terms[i]);
        }
    }

    public String toString(String field) {
        return this.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.queryString());
        buffer.append("(");
        for (int i = 0; i < this.terms.length; ++i) {
            buffer.append(this.terms[i].text());
            if (i == this.terms.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    protected abstract String queryString();

    public boolean equals(Object other) {
        if (other instanceof SpanCompoundTagQuery) {
            SpanCompoundTagQuery otherCompound = (SpanCompoundTagQuery)((Object)other);
            Iterator otherTermsIterator = otherCompound.getTerms().iterator();
            Iterator thisTermsIterator = this.getTerms().iterator();
            while (otherTermsIterator.hasNext()) {
                if (!thisTermsIterator.hasNext()) {
                    return false;
                }
                if (otherTermsIterator.next().equals(thisTermsIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

