/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search.spans;

import com.ibm.es.nuvo.markup.search.spans.TagSpans;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.search.spans.Spans;

public class IntersectSpans
implements Spans {
    private TagSpans[] spans;
    private SpanOccurrence[] nextOccurrences;
    private LinkedList[] openSpanOccurrences;
    private LinkedList spanOccurrencesPool;
    private LinkedList myNextSpanOccurrences;
    private boolean needToRefreshOnDoc;
    private int start;
    private int end;
    private int docid;
    private boolean stillPossible = true;

    public IntersectSpans(TagSpans[] spans_) {
        this.spans = spans_;
        this.spanOccurrencesPool = new LinkedList();
        this.myNextSpanOccurrences = new LinkedList();
        this.openSpanOccurrences = new LinkedList[this.spans.length];
        this.nextOccurrences = new SpanOccurrence[this.spans.length];
        for (int i = 0; i < this.spans.length; ++i) {
            try {
                this.spans[i].next();
            }
            catch (IOException ioe) {
                System.err.println("oi vey in constructor");
            }
            this.openSpanOccurrences[i] = new LinkedList();
            this.nextOccurrences[i] = new SpanOccurrence();
        }
        this.needToRefreshOnDoc = true;
        this.stillPossible = true;
        this.docid = 0;
        if (spans_.length == 0) {
            this.stillPossible = false;
        }
    }

    public boolean next() throws IOException {
        int i;
        if (!this.stillPossible) {
            this.docid = Integer.MAX_VALUE;
            return false;
        }
        if (this.needToRefreshOnDoc) {
            int maxDocId = this.docid;
            while (this.needToRefreshOnDoc) {
                this.needToRefreshOnDoc = false;
                for (i = 0; i < this.spans.length; ++i) {
                    if (this.spans[i].doc() <= maxDocId) continue;
                    maxDocId = this.spans[i].doc();
                    this.needToRefreshOnDoc = true;
                }
                if (maxDocId == Integer.MAX_VALUE) {
                    this.stillPossible = false;
                    this.docid = Integer.MAX_VALUE;
                    return false;
                }
                if (!this.needToRefreshOnDoc) continue;
                for (i = 0; i < this.spans.length; ++i) {
                    if (this.spans[i].doc() >= maxDocId) continue;
                    if (!this.spans[i].skipTo(maxDocId)) {
                        this.stillPossible = false;
                        this.docid = Integer.MAX_VALUE;
                        return false;
                    }
                    if (this.spans[i].doc() <= maxDocId) continue;
                    maxDocId = this.spans[i].doc();
                }
            }
            this.docid = maxDocId;
            if (this.myNextSpanOccurrences.size() > 0) {
                this.spanOccurrencesPool.addAll(this.myNextSpanOccurrences);
                this.myNextSpanOccurrences.clear();
            }
            for (i = 0; i < this.spans.length; ++i) {
                if (this.openSpanOccurrences[i].size() > 0) {
                    this.spanOccurrencesPool.addAll(this.openSpanOccurrences[i]);
                    this.openSpanOccurrences[i].clear();
                }
                this.nextOccurrences[i].set(this.spans[i].start(), this.spans[i].end());
            }
        }
        if (this.myNextSpanOccurrences.size() > 0) {
            this.start = ((SpanOccurrence)this.myNextSpanOccurrences.getFirst()).start();
            this.end = ((SpanOccurrence)this.myNextSpanOccurrences.getFirst()).end();
            this.myNextSpanOccurrences.removeFirst();
            return true;
        }
        int s = Integer.MAX_VALUE;
        for (i = 0; i < this.spans.length; ++i) {
            if (this.nextOccurrences[i].start() >= s) continue;
            s = this.nextOccurrences[i].start();
        }
        if (s == Integer.MAX_VALUE) {
            this.needToRefreshOnDoc = true;
            return this.next();
        }
        for (i = 0; i < this.spans.length; ++i) {
            while (this.openSpanOccurrences[i].size() > 0 && ((SpanOccurrence)this.openSpanOccurrences[i].getFirst()).end() <= s) {
                this.spanOccurrencesPool.add(this.openSpanOccurrences[i].getFirst());
                this.openSpanOccurrences[i].removeFirst();
            }
        }
        for (i = 0; i < this.spans.length; ++i) {
            while (this.nextOccurrences[i].start() == s) {
                if (this.nextOccurrences[i].start() < this.nextOccurrences[i].end()) {
                    SpanOccurrence occ = this.getEmptySpanOccurrence();
                    occ.set(s, this.nextOccurrences[i].end());
                    if (this.openSpanOccurrences[i].size() == 0) {
                        this.openSpanOccurrences[i].add(occ);
                    } else {
                        ListIterator li = this.openSpanOccurrences[i].listIterator();
                        int numOfOccsThatEndBefore = 0;
                        while (li.hasNext() && ((SpanOccurrence)li.next()).end() < occ.end()) {
                            ++numOfOccsThatEndBefore;
                        }
                        this.openSpanOccurrences[i].add(numOfOccsThatEndBefore, occ);
                    }
                }
                if (!this.spans[i].next() || this.spans[i].doc() > this.docid) {
                    this.nextOccurrences[i].set(Integer.MAX_VALUE, Integer.MAX_VALUE);
                    continue;
                }
                this.nextOccurrences[i].set(this.spans[i].start(), this.spans[i].end());
            }
        }
        for (i = 0; i < this.spans.length; ++i) {
            if (this.openSpanOccurrences[i].size() != 0) continue;
            return this.next();
        }
        this.produceAllInts(s, Integer.MAX_VALUE, 0);
        if (this.myNextSpanOccurrences.size() == 0) {
            throw new IOException("IntersectSpans myNext is surprisingly empty");
        }
        this.start = ((SpanOccurrence)this.myNextSpanOccurrences.getFirst()).start();
        this.end = ((SpanOccurrence)this.myNextSpanOccurrences.getFirst()).end();
        this.myNextSpanOccurrences.removeFirst();
        return true;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.docid < target) {
            this.docid = target;
            this.needToRefreshOnDoc = true;
            return this.next();
        }
        return this.next();
    }

    public int doc() {
        return this.docid;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public String toString() {
        String s = null;
        for (int i = 0; i < this.spans.length; ++i) {
            s = s + this.spans[i].toString();
        }
        return "IntersectSpans@" + s;
    }

    private SpanOccurrence getEmptySpanOccurrence() {
        if (this.spanOccurrencesPool.size() == 0) {
            return new SpanOccurrence();
        }
        return (SpanOccurrence)this.spanOccurrencesPool.removeLast();
    }

    private void produceAllInts(int tempStart, int tempEnd, int spansIndex) {
        ListIterator li = this.openSpanOccurrences[spansIndex].listIterator();
        while (li.hasNext()) {
            int end1;
            SpanOccurrence occ = (SpanOccurrence)li.next();
            int start1 = tempStart < occ.start() ? occ.start() : tempStart;
            int n = end1 = tempEnd < occ.end() ? tempEnd : occ.end();
            if (tempStart < occ.start()) {
                System.err.println("Dafna!!! notice produceAllInts, discovered a new open");
            }
            if (end1 <= start1) {
                System.err.println("Dafna!!! notice produceAllInts, end <= start");
            }
            if (spansIndex == this.spans.length - 1) {
                SpanOccurrence newOcc = this.getEmptySpanOccurrence();
                newOcc.set(start1, end1);
                this.addNoDupToMyNextSpanOccurrences(newOcc);
                continue;
            }
            this.produceAllInts(start1, end1, spansIndex + 1);
        }
    }

    private void addNoDupToMyNextSpanOccurrences(SpanOccurrence newOcc) {
        if (this.myNextSpanOccurrences.size() == 0) {
            this.myNextSpanOccurrences.add(newOcc);
            return;
        }
        ListIterator li = this.myNextSpanOccurrences.listIterator();
        while (li.hasNext()) {
            SpanOccurrence occ = (SpanOccurrence)li.next();
            if (occ.start() != newOcc.start()) {
                System.err.println("Dafna: two occs in myNext do not start the same");
            }
            if (occ.end() != newOcc.end()) continue;
            this.spanOccurrencesPool.add(newOcc);
            return;
        }
        this.myNextSpanOccurrences.add(newOcc);
    }

    private class SpanOccurrence {
        private int start1;
        private int end1;

        public int start() {
            return this.start1;
        }

        public int end() {
            return this.end1;
        }

        public void set(int start_, int end_) {
            this.start1 = start_;
            this.end1 = end_;
        }
    }
}

