/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.search.MarkupLeafNode;
import com.ibm.es.nuvo.markup.search.ReporterException;

class MarkupTwigReporter {
    static final int NO = 0;
    static final int POSSIBLY = 1;
    static final int YES = 2;
    static final int PENDING_SPAN = 3;
    static final int IRRELEVANT = 4;
    static final int NEVER_IN_THIS_DOC = 5;
    private static final String YES_STRING = "YES";
    private static final String NO_STRING = "NO";
    private static final String POSSIBLY_STRING = "POSSIBLY";
    private static final String PENDING_SPAN_STRING = "PENDING_SPAN";
    private static final String IRRELEVANT_STRING = "IRRELEVANT";
    private static final String NEVER_IN_THIS_DOC_STRING = "NEVER_IN_THIS_DOC";
    private int status;
    private MarkupLeafNode leafToMove;
    private int df;

    MarkupTwigReporter() {
    }

    void setYesStatus() {
        this.status = 2;
    }

    void setNoStatus() {
        this.status = 0;
    }

    void setNeverStatus() {
        this.status = 5;
    }

    boolean isYesStatus() {
        return this.status == 2;
    }

    boolean isNoStatus() {
        return this.status == 0;
    }

    boolean isNeverStatus() {
        return this.status == 5;
    }

    boolean isPossiblyStatus() {
        return this.status == 1;
    }

    boolean isPendingSpanStatus() {
        return this.status == 3;
    }

    boolean isIrrelevantStatus() {
        return this.status == 4;
    }

    void setPossiblyStatus(int df_, MarkupLeafNode leafToMove_) {
        this.status = 1;
        this.df = df_;
        this.leafToMove = leafToMove_;
    }

    void setPendingSpanStatus() {
        this.status = 3;
    }

    void setIrrelevantStatus() {
        this.status = 4;
    }

    int getDf() throws ReporterException {
        if (this.status != 1) {
            throw new ReporterException("We have not Df in status = " + this.getStatusString());
        }
        return this.df;
    }

    MarkupLeafNode getLeafToMove() throws ReporterException {
        if (this.status != 1) {
            throw new ReporterException("We have not leafToMove in status = " + this.getStatusString());
        }
        return this.leafToMove;
    }

    private String getStatusString() {
        if (this.status == 2) {
            return YES_STRING;
        }
        if (this.status == 0) {
            return NO_STRING;
        }
        if (this.status == 3) {
            return PENDING_SPAN_STRING;
        }
        if (this.status == 4) {
            return IRRELEVANT_STRING;
        }
        if (this.status == 5) {
            return NEVER_IN_THIS_DOC_STRING;
        }
        return POSSIBLY_STRING;
    }
}

