/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.search.spans.TagSpans;
import org.apache.lucene.search.spans.Spans;

class MarkupSpanOccurrence {
    private int doc;
    private int start;
    private int end;
    private int depth;
    private int id;
    private int lastID;
    private boolean fullDetailsOn;
    private int[] numofNeededPendingInBoolean = null;
    private int indexIntoNPIB;

    MarkupSpanOccurrence(int length) {
        this.numofNeededPendingInBoolean = new int[length];
    }

    protected void setInfinity() {
        this.doc = Integer.MAX_VALUE;
        this.start = Integer.MAX_VALUE;
        this.end = Integer.MAX_VALUE;
        this.depth = -1;
        this.id = -1;
        this.lastID = -1;
    }

    protected void setFromTagSpans(TagSpans tagSpans) {
        this.doc = tagSpans.doc();
        this.start = tagSpans.start();
        this.end = tagSpans.end();
        this.depth = tagSpans.depth();
        this.id = tagSpans.id();
        this.lastID = tagSpans.idLast();
        this.fullDetailsOn = true;
    }

    protected void setFromTagSpans_diet(TagSpans tagSpans) {
        this.doc = tagSpans.doc();
        this.start = tagSpans.start();
        this.fullDetailsOn = false;
    }

    protected void setFromTagSpans_complete(TagSpans tagSpans) {
        if (!this.fullDetailsOn) {
            this.end = tagSpans.end();
            this.depth = tagSpans.depth();
            this.id = tagSpans.id();
            this.lastID = tagSpans.idLast();
            this.fullDetailsOn = true;
        }
    }

    protected void setFromSpansNotTag(Spans spans) {
        this.doc = spans.doc();
        this.start = spans.start();
        this.end = spans.end();
        this.depth = -1;
        this.id = -1;
        this.lastID = -1;
        this.fullDetailsOn = true;
    }

    protected int indexIntoNPIB() {
        return this.indexIntoNPIB;
    }

    protected int doc() {
        return this.doc;
    }

    protected int start() {
        return this.start;
    }

    protected int end() {
        return this.end;
    }

    protected int depth() {
        return this.depth;
    }

    protected int id() {
        return this.id;
    }

    protected int lastID() {
        return this.lastID;
    }

    protected int getNumofNeededPendingInBoolean() {
        return this.numofNeededPendingInBoolean[this.indexIntoNPIB++];
    }

    protected void setNumofNeededPendingInBoolean(int num) {
        this.numofNeededPendingInBoolean[this.indexIntoNPIB++] = num;
    }

    protected void setNumofNeededPendingInBoolean(int index, int num) {
        this.numofNeededPendingInBoolean[index] = num;
    }

    protected void resetIndexIntoNPIB() {
        this.indexIntoNPIB = 0;
    }

    protected boolean needsToCompleteDetails() {
        return !this.fullDetailsOn;
    }
}

