/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.query.MarkupBooleanQuery;
import com.ibm.es.nuvo.markup.query.MarkupContainsQuery;
import com.ibm.es.nuvo.markup.query.MarkupContextQuery;
import com.ibm.es.nuvo.markup.query.MarkupLeafQuery;
import com.ibm.es.nuvo.markup.query.MarkupQuery;
import com.ibm.es.nuvo.markup.query.MarkupTagQuery;
import com.ibm.es.nuvo.markup.search.MarkupBooleanNode;
import com.ibm.es.nuvo.markup.search.MarkupContainsNode;
import com.ibm.es.nuvo.markup.search.MarkupDocumentReporter;
import com.ibm.es.nuvo.markup.search.MarkupLeafNode;
import com.ibm.es.nuvo.markup.search.MarkupNode;
import com.ibm.es.nuvo.markup.search.MarkupSpanOccurrence;
import com.ibm.es.nuvo.markup.search.ReporterException;
import com.ibm.es.nuvo.markup.search.ScoreParameters;
import com.ibm.es.nuvo.markup.util.IntArrayUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

public class MarkupScorer
extends Scorer {
    private float weightValue;
    private MarkupContainsNode root;
    private int numTwigRoots = 0;
    private boolean countLegalTwigsInScore;
    private boolean countTargetElementsInScore;
    private int[] elements = null;
    private boolean twigsFound = false;
    private boolean targetElementsFound = false;
    private int document = -1;
    private MarkupContainsNode[] allContainsNodesInQueryTwig;
    private MarkupDocumentReporter reporter = null;

    public MarkupScorer(IndexReader reader, MarkupContainsQuery.MarkupWeight weight, Similarity similarity, ScoreParameters scoreParameters) throws IOException {
        super(similarity);
        this.weightValue = weight.getValue();
        MarkupContainsQuery query = (MarkupContainsQuery)weight.getQuery();
        this.root = (MarkupContainsNode)this.buildCalculationTree(query, reader);
        ArrayList containsList = new ArrayList();
        this.root.preProcessTree(null, containsList);
        this.allContainsNodesInQueryTwig = containsList.toArray(new MarkupContainsNode[containsList.size()]);
        this.reporter = new MarkupDocumentReporter();
        this.countLegalTwigsInScore = scoreParameters.isCountLegalTwigs();
        this.countTargetElementsInScore = scoreParameters.isCountTargetElements();
    }

    private MarkupNode buildCalculationTree(MarkupQuery query_, IndexReader reader_) throws IOException {
        if (query_ instanceof MarkupLeafQuery) {
            MarkupLeafQuery leafQuery = (MarkupLeafQuery)query_;
            return new MarkupLeafNode(leafQuery.getSpans(reader_), leafQuery.getMinDocFreq(reader_), leafQuery.toString(), leafQuery.getWidth(), false);
        }
        if (query_ instanceof MarkupBooleanQuery) {
            MarkupBooleanQuery bQuery = (MarkupBooleanQuery)query_;
            BooleanClause[] clauses = bQuery.getClauses();
            int clausesLength = clauses == null ? 0 : clauses.length;
            MarkupNode[] contained = new MarkupNode[clausesLength];
            BooleanClause.Occur[] occurType = new BooleanClause.Occur[clausesLength];
            for (int i = 0; i < clausesLength; ++i) {
                occurType[i] = clauses[i].getOccur();
                contained[i] = this.buildCalculationTree((MarkupQuery)clauses[i].getQuery(), reader_);
            }
            if (query_ instanceof MarkupContainsQuery) {
                MarkupContainsQuery containsQuery = (MarkupContainsQuery)query_;
                MarkupContextQuery contextQuery = containsQuery.getMarkupContext();
                boolean isTargetElement = false;
                boolean isAttribute = false;
                if (contextQuery instanceof MarkupTagQuery) {
                    MarkupTagQuery tagQuery = (MarkupTagQuery)contextQuery;
                    isTargetElement = tagQuery.isTargetElement();
                    isAttribute = tagQuery.isAttribute();
                }
                MarkupLeafNode contextNode = new MarkupLeafNode(contextQuery.getSpans(reader_), contextQuery.getMinDocFreq(reader_), contextQuery.toString(), contextQuery.getWidth(), isAttribute);
                MarkupBooleanNode contents = new MarkupBooleanNode(containsQuery.getMinimumNumberShouldMatch(), contained, occurType);
                return new MarkupContainsNode(contextNode, contents, isTargetElement, containsQuery.getDepth());
            }
            MarkupBooleanQuery booleanQuery = (MarkupBooleanQuery)query_;
            return new MarkupBooleanNode(booleanQuery.getMinimumNumberShouldMatch(), contained, occurType);
        }
        throw new IOException("Illegal query type in SemanticWeight");
    }

    public int doc() {
        return this.document;
    }

    public Explanation explain(int doc) throws IOException {
        if (doc < 0) {
            throw new IOException("Illegal doc in explain");
        }
        Explanation explain = new Explanation();
        float score = 0.0f;
        if (this.document < doc && this.skipTo(doc) && this.document == doc) {
            score = this.score();
        }
        explain.setValue(this.getSimilarity().tf(score));
        if (score > 0.0f) {
            StringBuffer descript = new StringBuffer("tf(NumberOfLegalTwigs=" + this.numTwigRoots);
            if (this.countTargetElementsInScore) {
                descript.append(" + NumberOfTargetElemetns=" + this.numElements());
            }
            descript.append(")");
            explain.setDescription(descript.toString());
        }
        return explain;
    }

    public boolean next() throws IOException {
        this.numTwigRoots = 0;
        this.twigsFound = false;
        this.targetElementsFound = false;
        int targetedDoc = this.document + 1;
        while (true) {
            try {
                while (true) {
                    this.root.checkCandidateDocument(targetedDoc, this.reporter);
                    while (this.reporter.isPossiblyStatus()) {
                        this.reporter.getLeafToMove().advanceSpansToDoc(targetedDoc);
                        this.root.checkCandidateDocument(targetedDoc, this.reporter);
                    }
                    if (this.reporter.isNoStatus()) {
                        if (this.reporter.getFirstPossible() == Integer.MAX_VALUE) {
                            this.document = Integer.MAX_VALUE;
                            return false;
                        }
                        targetedDoc = this.reporter.getFirstPossible();
                        continue;
                    }
                    break;
                }
            }
            catch (ReporterException e) {
                System.err.println("We got an ReporterException in next method in MarkupScorer: " + e.getMessage());
                throw new IOException("We got an ReporterException in next method in MarkupScorer: " + e.getMessage());
            }
            if (this.root.isAttribute()) {
                if (!this.root.advanceSpansToDoc(targetedDoc)) {
                    return false;
                }
                if (!this.root.nextAttributeOccurrenceInDoc(targetedDoc)) {
                    ++targetedDoc;
                    continue;
                }
                this.document = targetedDoc;
                return true;
            }
            this.prepareContextOccurrences(targetedDoc);
            MarkupContainsNode earliestSpanOwner = this.findEarliestEventOwner();
            while (earliestSpanOwner != null) {
                if (earliestSpanOwner.checkOccurrenceAndAdvance() && earliestSpanOwner == this.root) {
                    this.document = targetedDoc;
                    this.numTwigRoots = 1;
                    return true;
                }
                earliestSpanOwner = this.findEarliestEventOwner();
            }
            ++targetedDoc;
        }
    }

    public boolean skipTo(int target) throws IOException {
        if (target > this.document) {
            this.document = target - 1;
        }
        return this.next();
    }

    public float score() throws IOException {
        int numTwigsAndTargetElements = 1;
        if (this.countLegalTwigsInScore) {
            this.findTwigs();
            numTwigsAndTargetElements = this.numTwigRoots;
        }
        if (this.countTargetElementsInScore) {
            this.findTagretElements();
            numTwigsAndTargetElements += this.elements.length;
        }
        return (float)numTwigsAndTargetElements * this.weightValue;
    }

    public void setCountTargetElementsInScore(boolean useTargetElementsInScore_) {
        this.countTargetElementsInScore = useTargetElementsInScore_;
    }

    private void findTwigs() throws IOException {
        if (this.twigsFound) {
            return;
        }
        if (this.root.isAttribute()) {
            this.numTwigRoots = 1;
            if (this.countLegalTwigsInScore) {
                while (this.root.nextAttributeOccurrenceInDoc(this.document)) {
                    ++this.numTwigRoots;
                }
            }
            this.twigsFound = true;
            return;
        }
        MarkupContainsNode earliestSpanOwner = this.findEarliestEventOwner();
        while (earliestSpanOwner != null) {
            earliestSpanOwner.checkOccurrenceAndAdvance();
            earliestSpanOwner = this.findEarliestEventOwner();
        }
        this.twigsFound = true;
        this.numTwigRoots = this.root.getSuccessfulSpanOccurrences().size();
    }

    private void findTagretElements() throws IOException {
        if (this.targetElementsFound) {
            return;
        }
        if (!this.twigsFound) {
            this.findTwigs();
        }
        this.screenSpanOccurences();
        this.collectTargetElements();
        this.targetElementsFound = true;
    }

    private void screenSpanOccurences() {
        for (int i = 1; i < this.allContainsNodesInQueryTwig.length; ++i) {
            if (!this.allContainsNodesInQueryTwig[i].leadsToTargetElement()) {
                LinkedList successful = this.allContainsNodesInQueryTwig[i].getSuccessfulSpanOccurrences();
                if (successful.size() <= 0) continue;
                this.allContainsNodesInQueryTwig[i].getSpanOccurrencesPool().addAll(successful);
                successful.clear();
                continue;
            }
            ListIterator li = this.allContainsNodesInQueryTwig[i].getSuccessfulSpanOccurrences().listIterator();
            MarkupContainsNode father = this.allContainsNodesInQueryTwig[i].getFather();
            while (li.hasNext()) {
                MarkupSpanOccurrence liocc = (MarkupSpanOccurrence)li.next();
                ListIterator liFather = father.getSuccessfulSpanOccurrences().listIterator();
                boolean withinFather = false;
                while (liFather.hasNext()) {
                    MarkupSpanOccurrence fatherOcc = (MarkupSpanOccurrence)liFather.next();
                    if (liocc.start() < fatherOcc.start() || liocc.end() > fatherOcc.end() || liocc.depth() != -1 && fatherOcc.depth() != -1 && (liocc.id() < fatherOcc.id() || liocc.id() > fatherOcc.lastID())) continue;
                    withinFather = true;
                    break;
                }
                if (withinFather) continue;
                li.remove();
            }
        }
    }

    private void collectTargetElements() {
        if (!this.containsTargetElements()) {
            this.elements = new int[0];
            this.targetElementsFound = true;
            return;
        }
        int numOfTEOccs = 0;
        for (int i = 0; i < this.allContainsNodesInQueryTwig.length; ++i) {
            if (!this.allContainsNodesInQueryTwig[i].isTargetElement()) continue;
            numOfTEOccs += this.allContainsNodesInQueryTwig[i].getSuccessfulSpanOccurrences().size();
        }
        if (numOfTEOccs == 0) {
            this.elements = new int[0];
            this.targetElementsFound = true;
            return;
        }
        int[] allTEOccs = new int[numOfTEOccs];
        int j = 0;
        for (int i = 0; i < this.allContainsNodesInQueryTwig.length; ++i) {
            if (!this.allContainsNodesInQueryTwig[i].isTargetElement()) continue;
            ListIterator li = this.allContainsNodesInQueryTwig[i].getSuccessfulSpanOccurrences().listIterator();
            while (li.hasNext()) {
                MarkupSpanOccurrence liocc = (MarkupSpanOccurrence)li.next();
                allTEOccs[j++] = liocc.id();
            }
        }
        Arrays.sort(allTEOccs);
        this.elements = IntArrayUtils.removeDuplicates(allTEOccs);
    }

    private int numElements() throws IOException {
        this.findTagretElements();
        return this.elements.length;
    }

    public int[] getElements() throws IOException {
        this.findTagretElements();
        return this.elements;
    }

    private void prepareContextOccurrences(int docid) throws IOException {
        for (int i = 0; i < this.allContainsNodesInQueryTwig.length; ++i) {
            this.allContainsNodesInQueryTwig[i].prepareFirstContextOccurrenceInDoc(docid);
        }
    }

    private MarkupContainsNode findEarliestEventOwner() {
        int i;
        int earliest = Integer.MAX_VALUE;
        int who = Integer.MAX_VALUE;
        for (i = 0; i < this.allContainsNodesInQueryTwig.length; ++i) {
            int start = this.allContainsNodesInQueryTwig[i].getNextSpanOccurrenceToCheckOnStart().start();
            if (start >= earliest) continue;
            earliest = start;
            who = i;
        }
        for (i = this.allContainsNodesInQueryTwig.length - 1; i >= 0; --i) {
            MarkupSpanOccurrence endOccur = this.allContainsNodesInQueryTwig[i].getNextOpenSpanOccurrenceToCheckOnEnd();
            if (endOccur == null || endOccur.end() >= earliest) continue;
            earliest = endOccur.end();
            who = i;
        }
        if (who < Integer.MAX_VALUE) {
            return this.allContainsNodesInQueryTwig[who];
        }
        return null;
    }

    public boolean containsTargetElements() {
        return this.root.leadsToTargetElement();
    }

    public MarkupNode getRootNode() {
        return this.root;
    }

    public MarkupContainsNode[] getAllContainsNodesInTwig() {
        return this.allContainsNodesInQueryTwig;
    }
}

