/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.search.MarkupContainsNode;
import com.ibm.es.nuvo.markup.search.MarkupDocumentReporter;
import com.ibm.es.nuvo.markup.search.MarkupNode;
import com.ibm.es.nuvo.markup.search.MarkupSpanOccurrence;
import com.ibm.es.nuvo.markup.search.MarkupTwigReporter;
import com.ibm.es.nuvo.markup.search.spans.TagSpans;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.spans.Spans;

public class MarkupLeafNode
implements MarkupNode {
    private Spans spans = null;
    private boolean spansValid;
    private int df;
    private int width;
    private String description;
    private boolean isAttribute;
    private boolean completeMatchRequired;

    MarkupLeafNode(Spans spans_, int df_, String description_, int width_, boolean isAttribute_) throws IOException {
        this(spans_, df_, description_, width_, isAttribute_, false);
    }

    MarkupLeafNode(Spans spans_, int df_, String description_, int width_, boolean isAttribute_, boolean completeMatchRequired) throws IOException {
        this.spans = spans_;
        this.spansValid = this.spans == null ? false : this.spans.next();
        this.df = df_;
        this.width = width_;
        this.description = description_;
        this.isAttribute = isAttribute_;
        this.completeMatchRequired = completeMatchRequired;
    }

    public void testNextSpanOccurrence(MarkupSpanOccurrence occ, MarkupTwigReporter reporter) {
        if (!this.spansValid) {
            reporter.setNeverStatus();
            return;
        }
        if (this.spans.doc() > occ.doc()) {
            reporter.setNeverStatus();
            return;
        }
        if (this.width > occ.end() - occ.start()) {
            reporter.setNoStatus();
            return;
        }
        if (this.spans.doc() < occ.doc()) {
            reporter.setPossiblyStatus(this.df, this);
            return;
        }
        if (this.spans.start() > occ.end()) {
            reporter.setNoStatus();
            return;
        }
        if (this.completeMatchRequired) {
            if (this.spans.start() != occ.start()) {
                reporter.setNoStatus();
                return;
            }
            if (this.spans.end() == occ.end()) {
                reporter.setYesStatus();
                return;
            }
        } else {
            if (this.spans.start() < occ.start()) {
                reporter.setPossiblyStatus(this.df, this);
                return;
            }
            if (this.spans.end() <= occ.end()) {
                reporter.setYesStatus();
                return;
            }
        }
        reporter.setNoStatus();
    }

    protected Spans spans() {
        return this.spans;
    }

    public void checkCandidateDocument(int docid, MarkupDocumentReporter reporter_) {
        if (!this.spansValid) {
            reporter_.setNoStatus(Integer.MAX_VALUE);
            return;
        }
        if (this.spans.doc() == docid) {
            reporter_.setYesStatus();
            return;
        }
        if (this.spans.doc() < docid) {
            reporter_.setPossiblyStatus(this.df, this);
            return;
        }
        reporter_.setNoStatus(this.spans.doc());
    }

    public boolean advanceSpansToDoc(int docid) throws IOException {
        if (!this.spansValid) {
            return false;
        }
        if (this.spans.doc() < docid) {
            this.spansValid = this.spans.skipTo(docid);
        }
        return this.spansValid;
    }

    public void testEndingOpenSpanOccurrence(MarkupSpanOccurrence occ, MarkupTwigReporter reporter) {
        reporter.setIrrelevantStatus();
    }

    public int countNumofSubBooleans() {
        return 0;
    }

    public void preProcessTree(MarkupContainsNode father, ArrayList allcontains) {
    }

    boolean advanceSpans() throws IOException {
        if (!this.spansValid) {
            return false;
        }
        this.spansValid = this.spans.next();
        return this.spansValid;
    }

    void advanceSpansToPositionInDoc(MarkupSpanOccurrence occ) throws IOException {
        if (this.spans.doc() < occ.doc() && !this.advanceSpansToDoc(occ.doc())) {
            return;
        }
        if (this.isAttribute) {
            while (this.spansValid && ((TagSpans)this.spans).doc() == occ.doc() && ((TagSpans)this.spans).id() < occ.id()) {
                this.spansValid = this.spans.next();
            }
            return;
        }
        while (this.spansValid && this.spans.doc() == occ.doc() && this.spans.start() < occ.start()) {
            this.spansValid = this.spans.next();
        }
    }

    int getDf() {
        return this.df;
    }

    boolean isAttribute() {
        return this.isAttribute;
    }

    public String toString(int indent) {
        return this.description;
    }

    public String toString() {
        return this.toString(0);
    }
}

