/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.search.MarkupLeafNode;
import com.ibm.es.nuvo.markup.search.ReporterException;

class MarkupDocumentReporter {
    private static final int ILLEGAL_VALUE = -1;
    static final int NO = 0;
    static final int POSSIBLY = 1;
    static final int YES = 2;
    private static final String YES_STRING = "YES";
    private static final String NO_STRING = "NO";
    private static final String POSSIBLY_STRING = "POSSIBLY";
    private int status = -1;
    private MarkupLeafNode leafToMove;
    private int df;
    private int firstPossible;

    void setYesStatus() {
        this.status = 2;
    }

    void setNoStatus(int firstPossible_) {
        this.status = 0;
        this.firstPossible = firstPossible_;
    }

    boolean isYesStatus() {
        return this.status == 2;
    }

    boolean isNoStatus() {
        return this.status == 0;
    }

    boolean isPossiblyStatus() {
        return this.status == 1;
    }

    void setPossiblyStatus(int df_, MarkupLeafNode leafToMove_) {
        this.status = 1;
        this.df = df_;
        this.leafToMove = leafToMove_;
    }

    int getDf() throws ReporterException {
        if (this.status != 1) {
            throw new ReporterException("We have not Df in status = " + this.getStatusString());
        }
        return this.df;
    }

    MarkupLeafNode getLeafToMove() throws ReporterException {
        if (this.status != 1) {
            throw new ReporterException("We have not leafToMove in status = " + this.getStatusString());
        }
        return this.leafToMove;
    }

    int getFirstPossible() throws ReporterException {
        if (this.status != 0) {
            throw new ReporterException("We have not firstPossible in status = " + this.getStatusString());
        }
        return this.firstPossible;
    }

    private String getStatusString() {
        if (this.status == 2) {
            return YES_STRING;
        }
        if (this.status == 0) {
            return NO_STRING;
        }
        return POSSIBLY_STRING;
    }
}

