/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.search.MarkupBooleanNode;
import com.ibm.es.nuvo.markup.search.MarkupDocumentReporter;
import com.ibm.es.nuvo.markup.search.MarkupLeafNode;
import com.ibm.es.nuvo.markup.search.MarkupNode;
import com.ibm.es.nuvo.markup.search.MarkupSpanOccurrence;
import com.ibm.es.nuvo.markup.search.MarkupTwigReporter;
import com.ibm.es.nuvo.markup.search.ReporterException;
import com.ibm.es.nuvo.markup.search.spans.TagSpans;
import com.ibm.es.nuvo.markup.util.BooleanQueryToString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

public class MarkupContainsNode
implements MarkupNode {
    private MarkupLeafNode context;
    private MarkupBooleanNode contents;
    private MarkupContainsNode father = null;
    private boolean contextIsTag = false;
    private boolean isTargetElement = false;
    private boolean leadsToTargetElement = false;
    private int depth;
    private LinkedList spanOccurrencesPool = null;
    private LinkedList openSpanOccurrences = null;
    private LinkedList successfulSpanOccurrences = null;
    private MarkupSpanOccurrence nextSpanOccurrenceToCheckOnStart = null;
    private MarkupSpanOccurrence nextOpenSpanOccurrenceToCheckOnEnd = null;
    private int nowCheckingDocid;
    private MarkupTwigReporter reporter = null;
    private int numofSubBooleans;

    MarkupContainsNode(MarkupLeafNode context_, MarkupBooleanNode contents_, boolean isTargetElement_, int depth_) {
        this.contents = contents_;
        this.context = context_;
        this.contextIsTag = this.context.spans() instanceof TagSpans;
        this.isTargetElement = this.contextIsTag && isTargetElement_;
        this.depth = depth_;
        this.spanOccurrencesPool = new LinkedList();
        this.openSpanOccurrences = new LinkedList();
        this.successfulSpanOccurrences = new LinkedList();
        this.numofSubBooleans = this.contents.countNumofSubBooleans();
        this.nextSpanOccurrenceToCheckOnStart = new MarkupSpanOccurrence(this.numofSubBooleans);
        this.reporter = new MarkupTwigReporter();
    }

    public void checkCandidateDocument(int docid, MarkupDocumentReporter reporter_) throws ReporterException {
        this.context.checkCandidateDocument(docid, reporter_);
        if (reporter_.isNoStatus()) {
            int contextFirstPossible = reporter_.getFirstPossible();
            this.contents.checkCandidateDocument(docid, reporter_);
            if (!reporter_.isNoStatus()) {
                reporter_.setNoStatus(contextFirstPossible);
            } else {
                int firstPossible = reporter_.getFirstPossible();
                firstPossible = contextFirstPossible > firstPossible ? contextFirstPossible : firstPossible;
                reporter_.setNoStatus(firstPossible);
            }
            return;
        }
        if (reporter_.isYesStatus()) {
            this.contents.checkCandidateDocument(docid, reporter_);
            return;
        }
        if (reporter_.isPossiblyStatus()) {
            int df = reporter_.getDf();
            MarkupLeafNode leafToMove = reporter_.getLeafToMove();
            this.contents.checkCandidateDocument(docid, reporter_);
            if (reporter_.isYesStatus()) {
                reporter_.setPossiblyStatus(df, leafToMove);
                return;
            }
            if (reporter_.isNoStatus()) {
                return;
            }
            if (df < reporter_.getDf()) {
                reporter_.setPossiblyStatus(df, leafToMove);
            }
        }
    }

    public void testNextSpanOccurrence(MarkupSpanOccurrence occ, MarkupTwigReporter reporter_) throws IOException {
        if (!this.isAttribute()) {
            if (this.nextSpanOccurrenceToCheckOnStart.doc() > occ.doc()) {
                reporter_.setNeverStatus();
                return;
            }
            if (this.nextSpanOccurrenceToCheckOnStart.start() > occ.end()) {
                reporter_.setNoStatus();
            } else {
                reporter_.setPendingSpanStatus();
            }
            return;
        }
        TagSpans tagSpans = (TagSpans)this.context.spans();
        if (tagSpans.doc() > occ.doc()) {
            reporter_.setNeverStatus();
            return;
        }
        if (tagSpans.id() < occ.id()) {
            reporter_.setPossiblyStatus(this.context.getDf(), this.context);
            return;
        }
        if (!(this.depth == 0 && tagSpans.id() == occ.id() || this.depth == -1 && tagSpans.id() > occ.id() && tagSpans.id() <= occ.lastID())) {
            reporter_.setNoStatus();
            return;
        }
        reporter_.setYesStatus();
        if (this.contents.getHasNoContent()) {
            return;
        }
        this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans((TagSpans)this.context.spans());
        this.nextSpanOccurrenceToCheckOnStart.resetIndexIntoNPIB();
        this.contents.testNextSpanOccurrence(this.nextSpanOccurrenceToCheckOnStart, reporter_);
        while (reporter_.isPossiblyStatus()) {
            try {
                reporter_.getLeafToMove().advanceSpansToPositionInDoc(this.nextSpanOccurrenceToCheckOnStart);
            }
            catch (ReporterException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            this.nextSpanOccurrenceToCheckOnStart.resetIndexIntoNPIB();
            this.contents.testNextSpanOccurrence(this.nextSpanOccurrenceToCheckOnStart, reporter_);
        }
    }

    public void testEndingOpenSpanOccurrence(MarkupSpanOccurrence occ, MarkupTwigReporter reporter_) {
        if (this.isAttribute()) {
            reporter_.setIrrelevantStatus();
            return;
        }
        reporter_.setNoStatus();
        if (this.successfulSpanOccurrences.size() == 0) {
            return;
        }
        ListIterator li = this.successfulSpanOccurrences.listIterator();
        while (li.hasNext()) {
            MarkupSpanOccurrence liocc = (MarkupSpanOccurrence)li.next();
            if (occ.depth() == -1 || liocc.depth() == -1) {
                if (this.depth != -1 || occ.start() > liocc.start() || liocc.end() > occ.end()) continue;
                reporter_.setYesStatus();
                return;
            }
            if (occ.id() >= liocc.id() || liocc.id() > occ.lastID() || this.depth != -1 && occ.depth() + this.depth != liocc.depth()) continue;
            reporter_.setYesStatus();
            return;
        }
    }

    public boolean advanceSpansToDoc(int docid) throws IOException {
        if (!this.contents.advanceSpansToDoc(docid)) {
            return false;
        }
        return this.context.advanceSpansToDoc(docid);
    }

    public int countNumofSubBooleans() {
        return 0;
    }

    public void preProcessTree(MarkupContainsNode father_, ArrayList allcontains) {
        if (!this.isAttribute()) {
            allcontains.add(this);
            this.father = father_;
            if (this.isTargetElement) {
                this.setLeadsToTargetElement();
            }
            this.contents.preProcessTree(this, allcontains);
        }
    }

    public String toString(int indent) {
        String result = "ContainsQuery : " + this.context.toString() + "\n";
        result = result + BooleanQueryToString.indentToString(indent + 2) + this.contents.toString(indent + 2);
        return result;
    }

    public String toString() {
        return this.toString(0);
    }

    boolean nextAttributeOccurrenceInDoc(int docid) throws IOException {
        while (this.context.spans().doc() == docid) {
            this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans((TagSpans)this.context.spans());
            this.nextSpanOccurrenceToCheckOnStart.resetIndexIntoNPIB();
            this.contents.testNextSpanOccurrence(this.nextSpanOccurrenceToCheckOnStart, this.reporter);
            while (this.reporter.isPossiblyStatus()) {
                try {
                    this.reporter.getLeafToMove().advanceSpansToPositionInDoc(this.nextSpanOccurrenceToCheckOnStart);
                }
                catch (ReporterException e) {
                    System.err.println("error in using reporter");
                }
                this.nextSpanOccurrenceToCheckOnStart.resetIndexIntoNPIB();
                this.contents.testNextSpanOccurrence(this.nextSpanOccurrenceToCheckOnStart, this.reporter);
            }
            this.context.advanceSpans();
            if (!this.reporter.isYesStatus()) continue;
            return true;
        }
        return false;
    }

    private boolean nextEventIsStart() {
        return this.nextOpenSpanOccurrenceToCheckOnEnd == null || this.nextOpenSpanOccurrenceToCheckOnEnd.end() >= this.nextSpanOccurrenceToCheckOnStart.start();
    }

    boolean checkOccurrenceAndAdvance() throws IOException {
        if (this.nextEventIsStart()) {
            return this.checkStartingSpanOccurrenceOnStartAndAdvance();
        }
        return this.checkOpenSpanOccurrenceOnEndAndAdvance();
    }

    private boolean checkStartingSpanOccurrenceOnStartAndAdvance() throws IOException {
        if (!this.isAnyFatherOccurrenceInterested()) {
            this.advanceToNextContextOccurrence();
            return false;
        }
        this.nextSpanOccurrenceToCheckOnStart.resetIndexIntoNPIB();
        if (this.nextSpanOccurrenceToCheckOnStart.needsToCompleteDetails() && (!this.contents.getHasNoContent() || this.isTargetElement)) {
            this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans_complete((TagSpans)this.context.spans());
        }
        this.contents.testNextSpanOccurrence(this.nextSpanOccurrenceToCheckOnStart, this.reporter);
        while (this.reporter.isPossiblyStatus()) {
            try {
                this.reporter.getLeafToMove().advanceSpansToPositionInDoc(this.nextSpanOccurrenceToCheckOnStart);
            }
            catch (ReporterException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            this.nextSpanOccurrenceToCheckOnStart.resetIndexIntoNPIB();
            this.contents.testNextSpanOccurrence(this.nextSpanOccurrenceToCheckOnStart, this.reporter);
        }
        if (this.reporter.isNeverStatus()) {
            this.nextSpanOccurrenceToCheckOnStart.setInfinity();
            return false;
        }
        if (!this.reporter.isNoStatus()) {
            MarkupSpanOccurrence checkOnStart = this.nextSpanOccurrenceToCheckOnStart;
            if (this.reporter.isYesStatus()) {
                this.successfulSpanOccurrences.add(checkOnStart);
            } else {
                this.openSpanOccurrences.add(checkOnStart);
                if (this.nextOpenSpanOccurrenceToCheckOnEnd == null || checkOnStart.end() < this.nextOpenSpanOccurrenceToCheckOnEnd.end()) {
                    this.nextOpenSpanOccurrenceToCheckOnEnd = checkOnStart;
                }
            }
            this.nextSpanOccurrenceToCheckOnStart = this.getEmptySpanOccurrence();
        }
        this.advanceToNextContextOccurrence();
        return this.reporter.isYesStatus();
    }

    private void advanceToNextContextOccurrence() throws IOException {
        if (!this.context.advanceSpans() || this.context.spans().doc() > this.nowCheckingDocid) {
            this.nextSpanOccurrenceToCheckOnStart.setInfinity();
        } else if (this.contextIsTag) {
            this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans_diet((TagSpans)this.context.spans());
        } else {
            this.nextSpanOccurrenceToCheckOnStart.setFromSpansNotTag(this.context.spans());
        }
    }

    private boolean checkOpenSpanOccurrenceOnEndAndAdvance() {
        MarkupSpanOccurrence checkOnEnd = this.nextOpenSpanOccurrenceToCheckOnEnd;
        checkOnEnd.resetIndexIntoNPIB();
        this.contents.testEndingOpenSpanOccurrence(checkOnEnd, this.reporter);
        this.openSpanOccurrences.remove(checkOnEnd);
        if (this.reporter.isYesStatus()) {
            this.successfulSpanOccurrences.add(checkOnEnd);
        } else {
            this.spanOccurrencesPool.add(checkOnEnd);
        }
        this.nextOpenSpanOccurrenceToCheckOnEnd = null;
        if (this.openSpanOccurrences.size() > 0) {
            ListIterator li = this.openSpanOccurrences.listIterator();
            if (li.hasNext()) {
                this.nextOpenSpanOccurrenceToCheckOnEnd = (MarkupSpanOccurrence)li.next();
            }
            while (li.hasNext()) {
                MarkupSpanOccurrence occ = (MarkupSpanOccurrence)li.next();
                if (occ.end() >= this.nextOpenSpanOccurrenceToCheckOnEnd.end()) continue;
                this.nextOpenSpanOccurrenceToCheckOnEnd = occ;
            }
        }
        return this.reporter.isYesStatus();
    }

    private boolean isAnyFatherOccurrenceInterested() {
        MarkupSpanOccurrence occ;
        ListIterator li;
        if (this.father == null) {
            if (this.depth == -1) {
                return true;
            }
            this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans_complete((TagSpans)this.context.spans());
            return this.depth == this.nextSpanOccurrenceToCheckOnStart.depth();
        }
        if (this.father.getOpenSpanOccurrences().size() > 0) {
            if (this.nextSpanOccurrenceToCheckOnStart.needsToCompleteDetails()) {
                this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans_complete((TagSpans)this.context.spans());
            }
            li = this.father.getOpenSpanOccurrences().listIterator();
            while (li.hasNext()) {
                occ = (MarkupSpanOccurrence)li.next();
                if (!this.isNowWithin(occ)) continue;
                return true;
            }
        }
        if (this.leadsToTargetElement && this.father.getSuccessfulSpanOccurrences().size() > 0) {
            if (this.nextSpanOccurrenceToCheckOnStart.needsToCompleteDetails()) {
                this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans_complete((TagSpans)this.context.spans());
            }
            li = this.father.getSuccessfulSpanOccurrences().listIterator();
            while (li.hasNext()) {
                occ = (MarkupSpanOccurrence)li.next();
                if (!this.isNowWithin(occ)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNowWithin(MarkupSpanOccurrence occ) {
        MarkupSpanOccurrence thisocc = this.nextSpanOccurrenceToCheckOnStart;
        if (thisocc.end() > occ.end()) {
            return false;
        }
        return !this.contextIsTag || thisocc.depth() == -1 || occ.depth() == -1 || thisocc.id() > occ.id() && thisocc.id() <= occ.lastID() && (this.depth == -1 || thisocc.depth() == this.depth + occ.depth());
    }

    void prepareFirstContextOccurrenceInDoc(int docid) throws IOException {
        if (this.openSpanOccurrences.size() > 0) {
            this.spanOccurrencesPool.addAll(this.openSpanOccurrences);
            this.openSpanOccurrences.clear();
        }
        if (this.successfulSpanOccurrences.size() > 0) {
            this.spanOccurrencesPool.addAll(this.successfulSpanOccurrences);
            this.successfulSpanOccurrences.clear();
        }
        this.advanceSpansToDoc(docid);
        this.nowCheckingDocid = docid;
        if (this.context.spans().doc() > docid) {
            this.nextSpanOccurrenceToCheckOnStart.setInfinity();
        } else if (this.contextIsTag) {
            this.nextSpanOccurrenceToCheckOnStart.setFromTagSpans_diet((TagSpans)this.context.spans());
        } else {
            this.nextSpanOccurrenceToCheckOnStart.setFromSpansNotTag(this.context.spans());
        }
        this.nextOpenSpanOccurrenceToCheckOnEnd = null;
    }

    private MarkupSpanOccurrence getEmptySpanOccurrence() {
        if (this.spanOccurrencesPool.size() == 0) {
            return new MarkupSpanOccurrence(this.numofSubBooleans);
        }
        return (MarkupSpanOccurrence)this.spanOccurrencesPool.removeLast();
    }

    public MarkupSpanOccurrence getNextSpanOccurrenceToCheckOnStart() {
        return this.nextSpanOccurrenceToCheckOnStart;
    }

    public MarkupSpanOccurrence getNextOpenSpanOccurrenceToCheckOnEnd() {
        return this.nextOpenSpanOccurrenceToCheckOnEnd;
    }

    public LinkedList getSuccessfulSpanOccurrences() {
        return this.successfulSpanOccurrences;
    }

    private LinkedList getOpenSpanOccurrences() {
        return this.openSpanOccurrences;
    }

    LinkedList getSpanOccurrencesPool() {
        return this.spanOccurrencesPool;
    }

    void setLeadsToTargetElement() {
        this.leadsToTargetElement = true;
        if (this.father != null) {
            this.father.setLeadsToTargetElement();
        }
    }

    public boolean leadsToTargetElement() {
        return this.leadsToTargetElement;
    }

    boolean isAttribute() {
        return this.context.isAttribute();
    }

    boolean isTargetElement() {
        return this.isTargetElement;
    }

    public MarkupContainsNode getFather() {
        return this.father;
    }

    public MarkupLeafNode getContext() {
        return this.context;
    }
}

