/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.search;

import com.ibm.es.nuvo.markup.search.MarkupContainsNode;
import com.ibm.es.nuvo.markup.search.MarkupDocumentReporter;
import com.ibm.es.nuvo.markup.search.MarkupLeafNode;
import com.ibm.es.nuvo.markup.search.MarkupNode;
import com.ibm.es.nuvo.markup.search.MarkupSpanOccurrence;
import com.ibm.es.nuvo.markup.search.MarkupTwigReporter;
import com.ibm.es.nuvo.markup.search.ReporterException;
import com.ibm.es.nuvo.markup.util.BooleanQueryToString;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;

class MarkupBooleanNode
implements MarkupNode {
    private MarkupNode[] containedMust;
    private MarkupNode[] containedMustNot;
    private MarkupNode[] containedShould;
    private int minNrShouldMatch;
    private boolean hasNoContent;

    MarkupBooleanNode(int minNrShouldMatch_, MarkupNode[] contained_, BooleanClause.Occur[] occurType) {
        this.minNrShouldMatch = minNrShouldMatch_;
        ArrayList<MarkupNode> musts = new ArrayList<MarkupNode>();
        ArrayList<MarkupNode> mustNots = new ArrayList<MarkupNode>();
        ArrayList<MarkupNode> shoulds = new ArrayList<MarkupNode>();
        for (int i = 0; i < contained_.length; ++i) {
            if (occurType[i] == BooleanClause.Occur.MUST) {
                musts.add(contained_[i]);
                continue;
            }
            if (occurType[i] == BooleanClause.Occur.MUST_NOT) {
                mustNots.add(contained_[i]);
                continue;
            }
            if (occurType[i] != BooleanClause.Occur.SHOULD) continue;
            shoulds.add(contained_[i]);
        }
        this.containedMust = musts.toArray(new MarkupNode[musts.size()]);
        this.containedMustNot = mustNots.toArray(new MarkupNode[mustNots.size()]);
        this.containedShould = shoulds.toArray(new MarkupNode[shoulds.size()]);
        this.hasNoContent = this.containedMust.length == 0 && this.containedMustNot.length == 0 && this.containedShould.length == 0;
    }

    public void checkCandidateDocument(int docid, MarkupDocumentReporter reporter) throws ReporterException {
        int i;
        if (this.hasNoContent) {
            reporter.setYesStatus();
            return;
        }
        int statusForMust = 2;
        int df = Integer.MAX_VALUE;
        int firstPossibleAmongShoulds = Integer.MAX_VALUE;
        int firstPossibleAmongMusts = -1;
        MarkupLeafNode leafToMove = null;
        int numOfMatchingShoulds = 0;
        int numOfPossiblyMatchingShoulds = 0;
        for (i = 0; i < this.containedMust.length; ++i) {
            this.containedMust[i].checkCandidateDocument(docid, reporter);
            if (reporter.isYesStatus()) continue;
            if (reporter.isNoStatus()) {
                if (firstPossibleAmongMusts < reporter.getFirstPossible()) {
                    firstPossibleAmongMusts = reporter.getFirstPossible();
                }
                statusForMust = 0;
                continue;
            }
            if (statusForMust == 0) continue;
            if (reporter.getDf() < df) {
                df = reporter.getDf();
                leafToMove = reporter.getLeafToMove();
            }
            statusForMust = 1;
        }
        if (statusForMust == 0) {
            reporter.setNoStatus(firstPossibleAmongMusts);
            return;
        }
        if (this.minNrShouldMatch == 0) {
            if (statusForMust == 2) {
                reporter.setYesStatus();
            } else {
                reporter.setPossiblyStatus(df, leafToMove);
            }
            return;
        }
        for (i = 0; i < this.containedShould.length; ++i) {
            this.containedShould[i].checkCandidateDocument(docid, reporter);
            if (reporter.isYesStatus()) {
                ++numOfMatchingShoulds;
                continue;
            }
            if (reporter.isNoStatus()) {
                if (firstPossibleAmongShoulds <= reporter.getFirstPossible()) continue;
                firstPossibleAmongShoulds = reporter.getFirstPossible();
                continue;
            }
            ++numOfPossiblyMatchingShoulds;
            if (statusForMust != 2 || df <= reporter.getDf()) continue;
            df = reporter.getDf();
            leafToMove = reporter.getLeafToMove();
        }
        if (statusForMust == 2 && numOfMatchingShoulds >= this.minNrShouldMatch) {
            reporter.setYesStatus();
            return;
        }
        if (numOfMatchingShoulds + numOfPossiblyMatchingShoulds >= this.minNrShouldMatch) {
            reporter.setPossiblyStatus(df, leafToMove);
        } else {
            reporter.setNoStatus(firstPossibleAmongShoulds);
        }
    }

    public boolean advanceSpansToDoc(int docid) throws IOException {
        int i;
        for (i = 0; i < this.containedMust.length; ++i) {
            if (this.containedMust[i].advanceSpansToDoc(docid)) continue;
            return false;
        }
        for (i = 0; i < this.containedMustNot.length; ++i) {
            this.containedMustNot[i].advanceSpansToDoc(docid);
        }
        int matchedShould = 0;
        for (int i2 = 0; i2 < this.containedShould.length; ++i2) {
            if (!this.containedShould[i2].advanceSpansToDoc(docid)) continue;
            ++matchedShould;
        }
        return matchedShould >= this.minNrShouldMatch;
    }

    public void testNextSpanOccurrence(MarkupSpanOccurrence occ, MarkupTwigReporter reporter) throws IOException {
        try {
            int reporterDf;
            int i;
            if (this.hasNoContent) {
                reporter.setYesStatus();
                return;
            }
            int statusForMust = 2;
            int df = Integer.MAX_VALUE;
            MarkupLeafNode leafToMove = null;
            int origIndexIntoNPIB = occ.indexIntoNPIB();
            occ.setNumofNeededPendingInBoolean(0);
            for (i = 0; i < this.containedMust.length; ++i) {
                this.containedMust[i].testNextSpanOccurrence(occ, reporter);
                if (reporter.isYesStatus()) continue;
                if (reporter.isNeverStatus()) {
                    reporter.setNeverStatus();
                    return;
                }
                if (reporter.isNoStatus()) {
                    reporter.setNoStatus();
                    return;
                }
                if (reporter.isPossiblyStatus()) {
                    reporterDf = reporter.getDf();
                    if (reporterDf < df) {
                        df = reporterDf;
                        leafToMove = reporter.getLeafToMove();
                    }
                    statusForMust = 1;
                    continue;
                }
                if (statusForMust != 2) continue;
                statusForMust = 3;
            }
            for (i = 0; i < this.containedMustNot.length; ++i) {
                this.containedMustNot[i].testNextSpanOccurrence(occ, reporter);
                if (reporter.isYesStatus()) {
                    reporter.setNoStatus();
                    return;
                }
                if (reporter.isNeverStatus() || reporter.isNoStatus()) continue;
                if (reporter.isPossiblyStatus()) {
                    reporterDf = reporter.getDf();
                    if (reporterDf < df) {
                        df = reporterDf;
                        leafToMove = reporter.getLeafToMove();
                    }
                    statusForMust = 1;
                    continue;
                }
                if (statusForMust != 2) continue;
                statusForMust = 3;
            }
            if (this.minNrShouldMatch == 0) {
                switch (statusForMust) {
                    case 2: {
                        reporter.setYesStatus();
                        break;
                    }
                    case 1: {
                        reporter.setPossiblyStatus(df, leafToMove);
                        break;
                    }
                    default: {
                        reporter.setPendingSpanStatus();
                    }
                }
                return;
            }
            int numOfMatchingShoulds = 0;
            int numOfPossiblyMatchingShoulds = 0;
            int numOfPendingSpansMatchingShoulds = 0;
            int numOfNeverInThisDocShoulds = 0;
            for (int i2 = 0; i2 < this.containedShould.length; ++i2) {
                this.containedShould[i2].testNextSpanOccurrence(occ, reporter);
                if (reporter.isYesStatus()) {
                    ++numOfMatchingShoulds;
                    continue;
                }
                if (reporter.isNeverStatus()) {
                    ++numOfNeverInThisDocShoulds;
                    continue;
                }
                if (reporter.isNoStatus()) continue;
                if (reporter.isPossiblyStatus()) {
                    int reporterDf2;
                    ++numOfPossiblyMatchingShoulds;
                    if (statusForMust == 1 || (reporterDf2 = reporter.getDf()) >= df) continue;
                    df = reporterDf2;
                    leafToMove = reporter.getLeafToMove();
                    continue;
                }
                ++numOfPendingSpansMatchingShoulds;
            }
            if (statusForMust == 2 && numOfMatchingShoulds >= this.minNrShouldMatch) {
                reporter.setYesStatus();
                return;
            }
            if (this.containedShould.length - numOfNeverInThisDocShoulds < this.minNrShouldMatch) {
                reporter.setNeverStatus();
                return;
            }
            if (numOfMatchingShoulds + numOfPossiblyMatchingShoulds + numOfPendingSpansMatchingShoulds < this.minNrShouldMatch) {
                reporter.setNoStatus();
                return;
            }
            if (statusForMust == 1 || numOfPossiblyMatchingShoulds > 0) {
                reporter.setPossiblyStatus(df, leafToMove);
            } else {
                reporter.setPendingSpanStatus();
                occ.setNumofNeededPendingInBoolean(origIndexIntoNPIB, this.minNrShouldMatch - numOfMatchingShoulds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void testEndingOpenSpanOccurrence(MarkupSpanOccurrence occ, MarkupTwigReporter reporter) {
        int i;
        if (this.hasNoContent) {
            reporter.setYesStatus();
            return;
        }
        int numOfMatchingShoulds = 0;
        int numPendingShouldsToMatch = occ.getNumofNeededPendingInBoolean();
        for (i = 0; i < this.containedMust.length; ++i) {
            this.containedMust[i].testEndingOpenSpanOccurrence(occ, reporter);
            if (reporter.isIrrelevantStatus() || !reporter.isNoStatus()) continue;
            reporter.setNoStatus();
            return;
        }
        for (i = 0; i < this.containedMustNot.length; ++i) {
            this.containedMustNot[i].testEndingOpenSpanOccurrence(occ, reporter);
            if (reporter.isIrrelevantStatus() || !reporter.isYesStatus()) continue;
            reporter.setNoStatus();
            return;
        }
        if (numPendingShouldsToMatch == 0) {
            reporter.setYesStatus();
            return;
        }
        for (i = 0; i < this.containedShould.length; ++i) {
            this.containedShould[i].testEndingOpenSpanOccurrence(occ, reporter);
            if (!reporter.isYesStatus() || ++numOfMatchingShoulds < numPendingShouldsToMatch) continue;
            reporter.setYesStatus();
            return;
        }
        reporter.setNoStatus();
    }

    public int countNumofSubBooleans() {
        int i;
        int ans = 1;
        for (i = 0; i < this.containedMust.length; ++i) {
            ans += this.containedMust[i].countNumofSubBooleans();
        }
        for (i = 0; i < this.containedMustNot.length; ++i) {
            ans += this.containedMustNot[i].countNumofSubBooleans();
        }
        for (i = 0; i < this.containedShould.length; ++i) {
            ans += this.containedShould[i].countNumofSubBooleans();
        }
        return ans;
    }

    public void preProcessTree(MarkupContainsNode father, ArrayList allcontains) {
        int i;
        for (i = 0; i < this.containedMust.length; ++i) {
            this.containedMust[i].preProcessTree(father, allcontains);
        }
        for (i = 0; i < this.containedMustNot.length; ++i) {
            this.containedMustNot[i].preProcessTree(father, allcontains);
        }
        for (i = 0; i < this.containedShould.length; ++i) {
            this.containedShould[i].preProcessTree(father, allcontains);
        }
    }

    protected boolean getHasNoContent() {
        return this.hasNoContent;
    }

    public String toString(int indent) {
        int i;
        String result = " BooleanQueryNode : \n";
        for (i = 0; i < this.containedMust.length; ++i) {
            result = result + BooleanQueryToString.indentToString(indent + 2) + BooleanQueryToString.OccurToString(BooleanClause.Occur.MUST) + " " + this.containedMust[i].toString(indent + 8) + "\n";
        }
        for (i = 0; i < this.containedMustNot.length; ++i) {
            result = result + BooleanQueryToString.indentToString(indent + 2) + BooleanQueryToString.OccurToString(BooleanClause.Occur.MUST_NOT) + " " + this.containedMustNot[i].toString(indent + 8) + "\n";
        }
        for (i = 0; i < this.containedShould.length; ++i) {
            result = result + BooleanQueryToString.indentToString(indent + 2) + BooleanQueryToString.OccurToString(BooleanClause.Occur.SHOULD) + " " + this.containedShould[i].toString(indent + 8) + "\n";
        }
        return result;
    }

    public String toString() {
        return this.toString(0);
    }
}

