/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.query;

import com.ibm.es.nuvo.markup.query.MarkupBooleanQuery;
import com.ibm.es.nuvo.markup.query.MarkupQuery;
import com.ibm.es.nuvo.markup.util.BooleanQueryToString;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public class MarkupOrQuery
extends MarkupBooleanQuery {
    private static final long serialVersionUID = -3586204430946504686L;

    public MarkupOrQuery() {
        super(BooleanClause.Occur.SHOULD);
        super.setMinimumNumberShouldMatch(0);
    }

    public MarkupOrQuery(boolean disableCoord) {
        super(disableCoord, BooleanClause.Occur.SHOULD);
        super.setMinimumNumberShouldMatch(0);
    }

    public void add(BooleanClause clause) {
        this.add(clause.getQuery(), clause.getOccur());
    }

    public void add(BooleanClause clause, boolean force) {
        this.add(clause.getQuery(), clause.getOccur(), force);
    }

    public void add(Query query_, BooleanClause.Occur occur_, boolean force) {
        BooleanClause.Occur occur = occur_ == BooleanClause.Occur.MUST && !force ? BooleanClause.Occur.SHOULD : occur_;
        Object query = query_;
        if (occur == BooleanClause.Occur.MUST_NOT) {
            MarkupOrQuery orQuery = new MarkupOrQuery();
            orQuery.addNotQuery(query_);
            occur = BooleanClause.Occur.SHOULD;
            query = orQuery;
        }
        super.add((Query)query, occur);
    }

    private void addNotQuery(Query query) {
        super.add(query, BooleanClause.Occur.MUST_NOT);
    }

    public void add(Query query, BooleanClause.Occur occur_) {
        this.add(query, occur_, false);
    }

    public String toString(int indent) {
        String str = "ORQuery :";
        str = str + "minShouldMatch : " + this.getMinimumNumberShouldMatch() + "\n";
        BooleanClause[] clauses = this.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            str = str + this.indentToStr(indent + 4) + BooleanQueryToString.OccurToString(clauses[i].getOccur()) + " - ";
            str = clauses[i].getQuery() instanceof MarkupQuery ? str + ((MarkupQuery)clauses[i].getQuery()).toString(indent + 4) : str + clauses[i].getQuery().toString();
            str = str + "\n";
        }
        return str;
    }

    public boolean equals(Object other) {
        if (other instanceof MarkupOrQuery) {
            return super.equals(other);
        }
        return false;
    }
}

