/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.query;

import com.ibm.es.nuvo.markup.query.MarkupQuery;
import com.ibm.es.nuvo.markup.search.spans.SpanMultiPhraseQuery;
import com.ibm.es.nuvo.markup.search.spans.SpanMultiTermQuery;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class MarkupLeafQuery
extends Query
implements MarkupQuery {
    private static final long serialVersionUID = -6104573942175469050L;
    SpanQuery spanQuery;
    Query query;
    private boolean isSpanMultiTermQuery;
    private boolean isSpanMultiPhraseQuery;
    private boolean completeMatchRequired;

    public MarkupLeafQuery(Query query_, SpanQuery spanQuery_) {
        this.spanQuery = spanQuery_;
        this.query = query_;
        this.isSpanMultiTermQuery = this.spanQuery instanceof SpanMultiTermQuery;
        this.isSpanMultiPhraseQuery = this.spanQuery instanceof SpanMultiPhraseQuery;
    }

    public Query getBooleanQuery() {
        return this.query;
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        Collection fields = reader.getFieldNames(IndexReader.FieldOption.INDEXED);
        if (!fields.contains(this.spanQuery.getField())) {
            return null;
        }
        return this.spanQuery.getSpans(reader);
    }

    public String getField() {
        return this.spanQuery.getField();
    }

    public int getWidth() {
        if (this.isSpanMultiPhraseQuery || this.isSpanMultiTermQuery) {
            return 1;
        }
        HashSet terms = new HashSet();
        this.spanQuery.extractTerms(terms);
        return terms.size();
    }

    public int getMinDocFreq(IndexReader reader) throws IOException {
        HashSet terms = new HashSet();
        if (this.isSpanMultiPhraseQuery) {
            ((SpanMultiPhraseQuery)this.spanQuery).extractTerms(terms);
        } else if (this.isSpanMultiTermQuery) {
            ((SpanMultiTermQuery)this.spanQuery).extractTerms(reader, terms);
        } else {
            this.spanQuery.extractTerms(terms);
        }
        if (terms.isEmpty()) {
            return 0;
        }
        Iterator it = terms.iterator();
        Term next = (Term)it.next();
        int minFreq = reader.docFreq(next);
        while (it.hasNext()) {
            next = (Term)it.next();
            int nextFreq = reader.docFreq(next);
            if (nextFreq >= minFreq) continue;
            nextFreq = minFreq;
        }
        return minFreq;
    }

    public void setCompleteMatchRequired(boolean yesno) {
        this.completeMatchRequired = yesno;
    }

    public boolean isCompleteMatchRequired() {
        return this.completeMatchRequired;
    }

    public String toString(String arg0) {
        return this.toString(0);
    }

    public String toString(int indent) {
        String str = "LeafQuery - " + this.spanQuery.toString();
        return str;
    }

    public boolean equals(Object other) {
        if (other instanceof MarkupLeafQuery) {
            MarkupLeafQuery otherLeafQuery = (MarkupLeafQuery)other;
            return otherLeafQuery.getBooleanQuery().equals(this.getBooleanQuery());
        }
        return false;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return this.spanQuery.weight(searcher);
    }
}

