/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.query;

import com.ibm.es.nuvo.markup.query.MarkupAttributeQuery;
import com.ibm.es.nuvo.markup.query.MarkupBooleanQuery;
import com.ibm.es.nuvo.markup.query.MarkupConcatQuery;
import com.ibm.es.nuvo.markup.query.MarkupContextQuery;
import com.ibm.es.nuvo.markup.query.MarkupIntersectQuery;
import com.ibm.es.nuvo.markup.query.MarkupQuery;
import com.ibm.es.nuvo.markup.query.MarkupQueryException;
import com.ibm.es.nuvo.markup.search.MarkupScorer;
import com.ibm.es.nuvo.markup.search.ScoreParameters;
import com.ibm.es.nuvo.markup.search.targetelement.TargetElementCollector;
import com.ibm.es.nuvo.markup.util.BooleanQueryToString;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class MarkupContainsQuery
extends MarkupBooleanQuery {
    private static final long serialVersionUID = -1827760388593554411L;
    private MarkupContextQuery context;
    private int depth;
    private Query rootQuery;
    private MarkupContainsQuery targetElementHandler;
    private HashMap targetElementMap;
    private ScoreParameters scoreParameters;

    public MarkupContainsQuery(BooleanClause.Occur defaultOccur_, MarkupContextQuery context_, int depth_) {
        super(defaultOccur_);
        this.context = context_;
        this.depth = depth_;
        this.setMinimumNumberShouldMatch(0);
        this.setContainsQuery();
        if (context_ instanceof MarkupAttributeQuery) {
            this.setAttributeQuery();
            if (depth_ != 0 && depth_ != -1) {
                this.depth = -1;
                System.err.println("We do not allow depth constraint on attributes.");
            }
        }
        if (context_ instanceof MarkupConcatQuery || context_ instanceof MarkupIntersectQuery) {
            this.setAnnotationQuery();
            if (depth_ != -1) {
                this.depth = -1;
                System.err.println("We do not allow depth constraint on annotations constraints.");
            }
        }
        this.targetElementMap = new HashMap();
    }

    public int getDepth() {
        return this.depth;
    }

    public MarkupContextQuery getMarkupContext() {
        return this.context;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new MarkupWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        MarkupContainsQuery clone = new MarkupContainsQuery(this.defaultOccur, this.context, this.depth);
        boolean isChanged = false;
        BooleanClause[] clauses = this.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            BooleanClause c = clauses[i];
            Query query = c.getQuery().rewrite(reader);
            clone.add(query, c.getOccur());
            if (query == c.getQuery()) continue;
            isChanged = true;
        }
        if (isChanged) {
            return clone;
        }
        return this;
    }

    public Weight weight(Searcher searcher) throws IOException {
        return new MarkupWeight(searcher);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(String arg0) {
        return this.toString(0);
    }

    public String toString(int indent) {
        String str = "[depth to parent = " + this.depth + "] - ContainsQuery (";
        str = str + "Context : " + this.context.toString() + ")";
        str = str + "minShouldMatch : " + this.getMinimumNumberShouldMatch() + "\n";
        BooleanClause[] clauses = this.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            str = str + this.indentToStr(indent + 4) + BooleanQueryToString.OccurToString(clauses[i].getOccur()) + " - " + ((MarkupQuery)clauses[i].getQuery()).toString(indent + 4) + "\n";
        }
        return str;
    }

    public boolean equals(Object other) {
        MarkupContainsQuery otherContains;
        if (other instanceof MarkupContainsQuery && (otherContains = (MarkupContainsQuery)other).getDepth() == this.getDepth() && otherContains.getMarkupContext().equals(this.getMarkupContext())) {
            return super.equals(other);
        }
        return false;
    }

    protected void setContainsNOTInItsPath() {
        super.setContainsNOTInItsPath();
        if (this.context.isTargetElement()) {
            this.context.setTargetElement(false);
            System.err.println("Target Element removed because a NOT occurs in the path");
        }
    }

    public BooleanQuery getBooleanQuery(boolean useContext, BooleanClause.Occur occur) {
        BooleanQuery result = super.getBooleanQuery(useContext, occur);
        if (useContext) {
            result.add(this.context.getBooleanQuery(), occur);
        }
        if (result.getClauses().length == 0) {
            return null;
        }
        return result;
    }

    public ScoreParameters getScoreParameters() {
        return this.scoreParameters;
    }

    public void setScoreParameters(ScoreParameters scoreParameters) {
        this.scoreParameters = scoreParameters;
    }

    public boolean hasTargetElements() {
        if (this.context.isTargetElement()) {
            return true;
        }
        return super.hasTargetElements();
    }

    public synchronized void setTargetElementCollector(TargetElementCollector targetElementCollector) throws InterruptedException, MarkupQueryException {
        Thread thread = Thread.currentThread();
        if (this.targetElementMap.containsKey(thread)) {
            throw new MarkupQueryException("MarkupContainsQuery " + this.toString() + "already assigned to a TargetElementCollector in thread " + thread.toString());
        }
        this.targetElementMap.put(thread, targetElementCollector);
    }

    public synchronized void setTargetElementHandlerAndRoot(MarkupContainsQuery handlerQuery, Query rootQuery_) throws MarkupQueryException {
        if (this.rootQuery == null) {
            this.rootQuery = rootQuery_;
            this.targetElementHandler = handlerQuery;
        } else if (this.rootQuery != rootQuery_) {
            throw new MarkupQueryException("MarkupContains Query already assigned to query " + this.rootQuery.toString() + ", cannot be assigned to query " + rootQuery_.toString());
        }
    }

    protected boolean selfHandler() {
        return this == this.targetElementHandler;
    }

    public class MarkupWeight
    implements Weight {
        private static final long serialVersionUID = -1951260489736065493L;
        private Similarity similarity;
        private Weight booleanWeight = null;

        public MarkupWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
            this.booleanWeight = ((MarkupBooleanQuery)this.getQuery()).getBooleanQuery(true, BooleanClause.Occur.MUST).weight(searcher);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            if (reader == null) {
                throw new IOException("Empty reader in explain method");
            }
            return null;
        }

        public Query getQuery() {
            return MarkupContainsQuery.this;
        }

        public float getValue() {
            return this.booleanWeight.getValue();
        }

        public void normalize(float norm) {
            this.booleanWeight.normalize(norm);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            if (MarkupContainsQuery.this.scoreParameters == null) {
                MarkupContainsQuery.this.scoreParameters = ScoreParameters.getDefaultParameters();
            }
            MarkupScorer markupScorer = new MarkupScorer(reader, this, this.similarity, MarkupContainsQuery.this.scoreParameters);
            if (MarkupContainsQuery.this.targetElementHandler != null) {
                MarkupContainsQuery handler = MarkupContainsQuery.this.targetElementHandler;
                Thread thread = Thread.currentThread();
                TargetElementCollector collector = (TargetElementCollector)((Object)handler.targetElementMap.get(thread));
                if (collector == null) {
                    throw new IOException("TargetElementCollector missing for thread " + thread.toString());
                }
                collector.addMarkupScorer(markupScorer);
                if (MarkupContainsQuery.this.selfHandler()) {
                    handler.targetElementMap.remove(thread);
                }
            }
            return markupScorer;
        }

        public float sumOfSquaredWeights() throws IOException {
            return this.booleanWeight.sumOfSquaredWeights();
        }
    }
}

