/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.markup.query;

import com.ibm.es.nuvo.markup.query.MarkupContainsQuery;
import com.ibm.es.nuvo.markup.query.MarkupLeafQuery;
import com.ibm.es.nuvo.markup.query.MarkupQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public abstract class MarkupBooleanQuery
extends BooleanQuery
implements MarkupQuery {
    private static final long serialVersionUID = -422044292454057772L;
    private MarkupBooleanQuery father;
    BooleanClause.Occur defaultOccur;
    private boolean containsNOTInItsPath;
    private boolean isContainsQuery;
    private boolean isAttributeQuery;
    private boolean isAnnotationQuery;
    private boolean hasMustClause;

    MarkupBooleanQuery(BooleanClause.Occur defaultOccur_) {
        this.defaultOccur = defaultOccur_;
        this.containsNOTInItsPath = false;
        this.isAttributeQuery = false;
        this.isContainsQuery = false;
        this.isAnnotationQuery = false;
        this.hasMustClause = false;
    }

    MarkupBooleanQuery(boolean disableCoord, BooleanClause.Occur defaultOccur_) {
        super(disableCoord);
        this.defaultOccur = defaultOccur_;
        this.containsNOTInItsPath = false;
    }

    public void add(Query query, BooleanClause.Occur occur_, boolean force) {
        this.add(query, occur_);
    }

    public void add(BooleanClause clause, boolean force) {
        this.add(clause);
    }

    public void add(Query query, BooleanClause.Occur occur) {
        if (query instanceof MarkupBooleanQuery) {
            if (((MarkupBooleanQuery)query).isAttributeQuery() && this.isAnnotationQuery()) {
                System.err.println("We do not allow some attributes in Annotation tags. We will ignore it.");
                return;
            }
            ((MarkupBooleanQuery)query).setFather(this);
            if (occur == BooleanClause.Occur.MUST_NOT || this.containsNOTInItsPath()) {
                ((MarkupBooleanQuery)query).setContainsNOTInItsPath();
            }
        }
        if (occur == BooleanClause.Occur.MUST) {
            this.hasMustClause = true;
            this.setMinimumNumberShouldMatch(0);
        } else if (occur == BooleanClause.Occur.SHOULD) {
            this.setMinimumNumberShouldMatch(1);
        }
        super.add(new BooleanClause(query, occur));
    }

    public void add(BooleanClause clause) {
        Query query = clause.getQuery();
        BooleanClause.Occur occur = clause.getOccur();
        this.add(query, occur);
    }

    public void setMinimumNumberShouldMatch(int nbrShouldMatch) {
        if (nbrShouldMatch == 0) {
            super.setMinimumNumberShouldMatch(0);
        } else if (nbrShouldMatch == 1 && !this.hasMustClause) {
            super.setMinimumNumberShouldMatch(1);
        }
    }

    public BooleanQuery getBooleanQuery(boolean useContext, BooleanClause.Occur occur_) {
        BooleanQuery result = new BooleanQuery();
        BooleanClause[] clauses = this.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            Query clauseQuery = clauses[i].getQuery();
            if (clauseQuery instanceof MarkupQuery) {
                if (clauseQuery instanceof MarkupBooleanQuery) {
                    clauseQuery = clauseQuery instanceof MarkupContainsQuery ? ((MarkupContainsQuery)clauseQuery).getBooleanQuery(useContext, occur_) : ((MarkupBooleanQuery)clauseQuery).getBooleanQuery(useContext, occur_);
                } else if (clauseQuery instanceof MarkupLeafQuery) {
                    clauseQuery = ((MarkupLeafQuery)clauseQuery).getBooleanQuery();
                }
            }
            if (clauseQuery == null) continue;
            result.add(clauseQuery, clauses[i].getOccur());
        }
        return result;
    }

    public MarkupBooleanQuery getFather() {
        return this.father;
    }

    void setFather(MarkupBooleanQuery query) {
        this.father = query;
    }

    boolean containsNOTInItsPath() {
        return this.containsNOTInItsPath;
    }

    void setContainsNOTInItsPath() {
        this.containsNOTInItsPath = true;
    }

    public boolean hasTargetElements() {
        BooleanClause[] clauses = this.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            Query clauseQuery = clauses[i].getQuery();
            if (!(clauseQuery instanceof MarkupBooleanQuery) || !(clauseQuery instanceof MarkupContainsQuery ? ((MarkupContainsQuery)clauseQuery).hasTargetElements() : ((MarkupBooleanQuery)clauseQuery).hasTargetElements())) continue;
            return true;
        }
        return false;
    }

    public boolean hasContainsSubNodes() {
        if (this instanceof MarkupContainsQuery) {
            return true;
        }
        BooleanClause[] clauses = this.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            Query clauseQuery = clauses[i].getQuery();
            if (!(clauseQuery instanceof MarkupBooleanQuery) || !((MarkupBooleanQuery)clauseQuery).hasContainsSubNodes()) continue;
            return true;
        }
        return false;
    }

    public boolean isContainsQuery() {
        return this.isContainsQuery;
    }

    public boolean isAnnotationQuery() {
        return this.isAnnotationQuery;
    }

    public boolean isAttributeQuery() {
        return this.isAttributeQuery;
    }

    void setContainsQuery() {
        this.isContainsQuery = true;
    }

    void setAttributeQuery() {
        this.isAttributeQuery = true;
    }

    void setAnnotationQuery() {
        this.isAnnotationQuery = true;
    }

    public String toString() {
        return this.toString(0);
    }

    public abstract String toString(int var1);

    String indentToStr(int indent) {
        String res = "";
        for (int i = 0; i < indent; ++i) {
            res = res + " ";
        }
        return res;
    }

    public boolean equals(Object other) {
        if (other instanceof MarkupBooleanQuery) {
            MarkupBooleanQuery boolOther = (MarkupBooleanQuery)other;
            BooleanClause[] thisClause = this.getClauses();
            BooleanClause[] otherClause = boolOther.getClauses();
            if (thisClause == null && otherClause == null) {
                return true;
            }
            if (thisClause != null && otherClause != null && otherClause.length == thisClause.length) {
                for (int i = 0; i < thisClause.length; ++i) {
                    if (thisClause[i].equals((Object)otherClause[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

