/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.manager;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.ShutdownPendingException;
import com.ibm.es.nuvo.manager.IndexerTask;

public class RebuildCollectionTask
extends IndexerTask {
    public RebuildCollectionTask(String collectionId, DocumentIndexer indexer) {
        super(collectionId, indexer);
    }

    public boolean isMultiInstances() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ConfigurationManagerException, IndexerException, ShutdownPendingException {
        ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration config = configManager.getCollectionForUpdate(this.getCollectionId());
        config.setRebuildState(CollectionConfiguration.RebuildState.InProgress);
        try {
            configManager.updateCollection(config);
            this.getDocumentIndexer().initiateIndexRebuild(this.getCollectionId());
        }
        catch (ConfigurationObjectNotExistsException e) {
            e.printStackTrace();
        }
        finally {
            RebuildCollectionTask rebuildCollectionTask = this;
            synchronized (rebuildCollectionTask) {
                this.notifyAll();
            }
        }
    }
}

