/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.manager;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionBadStateException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.ShutdownPendingException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.manager.IndexManager;
import com.ibm.es.nuvo.manager.IndexerTask;
import java.util.logging.Level;

public class IndexerThread
extends Thread {
    private IndexManager manager;
    private volatile boolean stop = false;
    private IndexerTask task;
    private int emptyWait;
    boolean anchorTextProcessed = false;

    public IndexerThread(IndexManager manager, int emptyWait, String name) {
        super(name);
        this.manager = manager;
        this.emptyWait = emptyWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            IndexerException indexerException;
            this.task = this.manager.getNextTask(this.task);
            if (this.task == null) {
                try {
                    Thread.sleep(this.emptyWait);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            try {
                this.task.run();
            }
            catch (CollectionBadStateException e) {
                if (CollectionConfiguration.State.DeletePending.equals((Object)e.getState()) || !Loggers.logger.isLoggable(Level.SEVERE)) continue;
                indexerException = new IndexerException(new Message("I0014E.CANNOT_PROCESSS_DOCUMENTS", this.task.getCollectionId()), (Throwable)e);
                Loggers.logger.log(indexerException);
            }
            catch (ConfigurationManagerException e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) continue;
                indexerException = new IndexerException(new Message("I0014E.CANNOT_PROCESSS_DOCUMENTS", this.task.getCollectionId()), (Throwable)e);
                Loggers.logger.log(indexerException);
            }
            catch (IndexerException e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) continue;
                indexerException = new IndexerException(new Message("I0019E.CANNOT_INDEX_DOCUMENT", this.task.getCollectionId()), (Throwable)e);
                Loggers.logger.log(indexerException);
            }
            catch (ShutdownPendingException e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) continue;
                indexerException = new IndexerException(new Message("I0014E.CANNOT_PROCESSS_DOCUMENTS", this.task.getCollectionId()), (Throwable)e);
                Loggers.logger.log(indexerException);
            }
            catch (Throwable e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) continue;
                indexerException = new IndexerException(new Message("I0019E.CANNOT_INDEX_DOCUMENT", this.task.getCollectionId()), e);
                Loggers.logger.log(indexerException);
            }
            finally {
                this.task.taskFinished();
            }
        }
        if (this.task != null) {
            this.manager.removeTask(this.task);
        }
    }

    void stopProcessing(boolean force) {
        this.stop = true;
        if (force && this.task != null) {
            this.task.setForceStop();
        }
    }
}

