/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.manager;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.logging.LoggedQuery;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class IndexThrottler
extends Handler {
    LinkedList<QueryTime> timeSeries = new LinkedList();
    private static int MaxWindow = 100;
    private long cachedValue = 0L;
    private long cachedDate = 0L;
    private static long MaxCacheTime = 1000L;
    private boolean recalculate = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        try {
            LoggedQuery query = new LoggedQuery(record);
            long responseTime = query.getQueryResponseTime();
            LinkedList<QueryTime> linkedList = this.timeSeries;
            synchronized (linkedList) {
                if (this.timeSeries.size() > MaxWindow) {
                    this.timeSeries.removeFirst();
                }
                this.timeSeries.addLast(new QueryTime(new Date(), responseTime));
            }
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public long getThrottle() {
        if (this.recalculate && (this.cachedDate == 0L || new Date().getTime() - this.cachedDate > MaxCacheTime)) {
            this.cachedValue = this.calculateThrottle();
            this.cachedDate = new Date().getTime();
        }
        return this.cachedValue;
    }

    public void setPermanentCacheValue(long cacheValue) {
        this.cachedValue = cacheValue;
        this.recalculate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateThrottle() {
        double factor = 0.0;
        long currentTime = new Date().getTime();
        LinkedList<QueryTime> linkedList = this.timeSeries;
        synchronized (linkedList) {
            ListIterator iterator = this.timeSeries.listIterator();
            while (iterator.hasNext()) {
                QueryTime queryTime = (QueryTime)iterator.next();
                long timeDifference = (currentTime - queryTime.timeStamp) / 10L;
                if (timeDifference == 0L) continue;
                factor += (double)queryTime.responseTime / (double)timeDifference;
            }
        }
        return new Double(factor).longValue();
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    class QueryTime {
        public long responseTime;
        public long timeStamp;

        public QueryTime(Date timeStamp, long responseTime) {
            this.timeStamp = timeStamp.getTime();
            this.responseTime = responseTime;
        }
    }
}

