/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.manager;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.manager.AnchorTextTask;
import com.ibm.es.nuvo.manager.CloseCollectionTask;
import com.ibm.es.nuvo.manager.DeactivateCollectionTask;
import com.ibm.es.nuvo.manager.DocumentIndexerTask;
import com.ibm.es.nuvo.manager.IndexRebuildTask;
import com.ibm.es.nuvo.manager.IndexerTask;
import com.ibm.es.nuvo.manager.IndexerThread;
import com.ibm.es.nuvo.manager.RebuildCollectionTask;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexManager
implements Runnable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String IndexerThreadNamePrefix = "IndexerThread";
    public static final int DefaultAnchorTextTrigger = 200;
    public static final int EmptyWait = 5000;
    public static final int DefaultMaxIdleCount = 10;
    public static final int IdleSweepCount = 60;
    public static final int IdleSleepSecond = 1;
    public static final double DefaultAnchorTextProbability = 0.5;
    DocumentQueueInterface documentQueue;
    DocumentIndexer documentIndexer;
    private Vector<IndexerTask> activeIndexes;
    private Vector<IndexerTask> waitingTasks;
    private Vector<String> quiescedCollection;
    private IndexerThread[] indexers;
    volatile int numberOfDocumentsProcessed;
    Random generator = new Random();
    private Sweeper indexSweeper;
    private double anchorTextProbability = 0.5;
    private boolean isConcurrent = false;

    public IndexManager(int concurrentIndexes, DocumentQueueInterface documentQueue) {
        this(concurrentIndexes, documentQueue, false);
    }

    public IndexManager(int concurrentIndexes, DocumentQueueInterface documentQueue, boolean concurrent) {
        this.documentIndexer = new DocumentIndexer(concurrentIndexes, concurrent);
        this.waitingTasks = new Vector();
        this.activeIndexes = new Vector(concurrentIndexes);
        this.documentQueue = documentQueue;
        this.numberOfDocumentsProcessed = 0;
        this.isConcurrent = concurrent;
        this.indexers = new IndexerThread[concurrentIndexes];
        this.quiescedCollection = new Vector();
    }

    public DocumentIndexer getDocumentIndexer() {
        return this.documentIndexer;
    }

    public void setConcurrent(boolean concurrent) {
        this.isConcurrent = concurrent;
        if (this.documentIndexer != null) {
            this.documentIndexer.setConcurrent(concurrent);
        }
    }

    private synchronized IndexerTask getNextTaskConcurrent(IndexerTask activeTask) {
        IndexerTask nextTask = null;
        if (nextTask == null) {
            nextTask = this.getNextTextIndexerTaskConcurrent(activeTask);
        }
        if (nextTask == null) {
            nextTask = this.getNextIndexRebuildTask();
        }
        if (nextTask == null) {
            nextTask = this.getNextAnchorTextTask();
        }
        if (nextTask != null) {
            if (!nextTask.isMultiInstances() && this.isCollectionActive(nextTask.getCollectionId())) {
                this.waitingTasks.add(nextTask);
                return null;
            }
            this.activeIndexes.add(nextTask);
            return nextTask;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCollection(String collectionId) throws InterruptedException {
        CloseCollectionTask task;
        CloseCollectionTask closeCollectionTask = task = new CloseCollectionTask(collectionId, this.documentIndexer);
        synchronized (closeCollectionTask) {
            this.waitingTasks.add(task);
            task.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateCollection(String collectionId) throws InterruptedException {
        DeactivateCollectionTask task;
        DeactivateCollectionTask deactivateCollectionTask = task = new DeactivateCollectionTask(collectionId, this.documentIndexer, this);
        synchronized (deactivateCollectionTask) {
            this.waitingTasks.add(task);
            task.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildCollection(String collectionId) throws InterruptedException {
        RebuildCollectionTask task;
        RebuildCollectionTask rebuildCollectionTask = task = new RebuildCollectionTask(collectionId, this.documentIndexer);
        synchronized (rebuildCollectionTask) {
            this.waitingTasks.add(task);
            task.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markQuiesced(String collectionId) {
        Vector<String> vector = this.quiescedCollection;
        synchronized (vector) {
            this.quiescedCollection.add(collectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateCollection(String collectionId) {
        Vector<String> vector = this.quiescedCollection;
        synchronized (vector) {
            this.quiescedCollection.remove(collectionId);
        }
    }

    private boolean isCollectionActive(String collectionId) {
        Iterator<IndexerTask> iterator = this.activeIndexes.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getCollectionId().equals(collectionId)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeTask(IndexerTask activeTask) {
        this.activeIndexes.remove(activeTask);
    }

    private IndexerTask getNextReadyWaitingTask() {
        IndexerTask nextTask = null;
        for (IndexerTask task : this.waitingTasks) {
            if (this.isCollectionActive(task.getCollectionId())) continue;
            nextTask = task;
        }
        if (nextTask != null) {
            this.waitingTasks.remove(nextTask);
        }
        return nextTask;
    }

    public synchronized IndexerTask getNextTask(IndexerTask activeTask) {
        IndexerTask nextTask;
        if (activeTask != null) {
            this.removeTask(activeTask);
        }
        if ((nextTask = this.getNextReadyWaitingTask()) == null && this.isConcurrent) {
            return this.getNextTaskConcurrent(activeTask);
        }
        if (nextTask == null) {
            nextTask = this.getNextTextIndexerTask(activeTask);
        }
        if (nextTask == null) {
            nextTask = this.getNextIndexRebuildTask();
        }
        if (nextTask == null) {
            nextTask = this.getNextAnchorTextTask();
        }
        if (nextTask != null) {
            this.activeIndexes.add(nextTask);
        }
        return nextTask;
    }

    public void setAnchorTextProbability(double probability) {
        this.anchorTextProbability = probability;
    }

    private IndexerTask getWaitingTask(String collectionId) {
        if (this.waitingTasks.size() == 0) {
            return null;
        }
        for (IndexerTask task : this.waitingTasks) {
            if (!task.getCollectionId().equals(collectionId)) continue;
            return task;
        }
        return null;
    }

    private void filterActiveTasks(Vector<String> candidates) {
        Iterator<IndexerTask> iterator = this.activeIndexes.iterator();
        while (iterator.hasNext()) {
            candidates.remove(iterator.next().getCollectionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterQuiescedTasks(Vector<String> candidates) {
        Vector<String> vector = this.quiescedCollection;
        synchronized (vector) {
            Iterator<String> iterator = this.quiescedCollection.iterator();
            while (iterator.hasNext()) {
                candidates.remove(iterator.next());
            }
        }
    }

    private void filterNonMultipleInstancesTasks(Vector<String> candidates) {
        for (IndexerTask task : this.activeIndexes) {
            if (task.isMultiInstances()) continue;
            candidates.remove(task.getCollectionId());
        }
    }

    private void filterWaitingTasks(Vector<String> candidates) {
        Iterator<IndexerTask> iterator = this.waitingTasks.iterator();
        while (iterator.hasNext()) {
            candidates.remove(iterator.next().getCollectionId());
        }
    }

    private IndexerTask getNextTextIndexerTaskConcurrent(IndexerTask activeTask) {
        Vector<String> candidateCollections = new Vector<String>();
        this.documentQueue.getAllCollections(candidateCollections);
        this.filterWaitingTasks(candidateCollections);
        this.filterQuiescedTasks(candidateCollections);
        this.filterNonMultipleInstancesTasks(candidateCollections);
        if (candidateCollections.size() > 0) {
            String newCollection = this.randomPick(candidateCollections);
            return new DocumentIndexerTask(newCollection, this.documentIndexer, this.documentQueue);
        }
        if (activeTask != null) {
            if (activeTask instanceof DocumentIndexerTask) {
                DocumentIndexerTask task = (DocumentIndexerTask)activeTask;
                if (task.getDocumentsProcessed() > 200L || task.getIdleCount() > 10L || this.getWaitingTask(activeTask.getCollectionId()) != null) {
                    return null;
                }
                return activeTask;
            }
            return null;
        }
        return null;
    }

    private IndexerTask getNextTextIndexerTask(IndexerTask activeTask) {
        Vector<String> candidateCollections = new Vector<String>();
        this.documentQueue.getAllCollections(candidateCollections);
        this.filterWaitingTasks(candidateCollections);
        this.filterActiveTasks(candidateCollections);
        this.filterQuiescedTasks(candidateCollections);
        if (candidateCollections.size() > 0) {
            String newCollection = this.randomPick(candidateCollections);
            return new DocumentIndexerTask(newCollection, this.documentIndexer, this.documentQueue);
        }
        if (activeTask != null) {
            if (activeTask instanceof DocumentIndexerTask) {
                DocumentIndexerTask task = (DocumentIndexerTask)activeTask;
                if (task.getDocumentsProcessed() > 200L || task.getIdleCount() > 10L) {
                    return null;
                }
                return activeTask;
            }
            return null;
        }
        return null;
    }

    private Vector<String> getAnchorTextCollectionIds() {
        Vector<String> collectionIds = GlobalSystem.getSingleInstance().getConfigurationManager().getCollectionIds();
        Vector<String> anchorTextIds = new Vector<String>();
        Iterator<String> it = collectionIds.iterator();
        boolean anchorText = false;
        while (it.hasNext()) {
            try {
                String collectionId = it.next();
                anchorText = AnchorTextTask.getAnchorTextIndexDescriptor(collectionId) != null;
                if (!anchorText) continue;
                anchorTextIds.add(collectionId);
            }
            catch (ConfigurationManagerException e) {}
        }
        return anchorTextIds;
    }

    private IndexerTask getNextIndexRebuildTask() {
        Vector<String> collectionIds = this.getRebuildingCollectionIds();
        this.filterWaitingTasks(collectionIds);
        this.filterActiveTasks(collectionIds);
        this.filterQuiescedTasks(collectionIds);
        String collectionId = this.randomPick(collectionIds);
        if (collectionId != null) {
            if (this.getWaitingTask(collectionId) == null) {
                IndexRebuildTask rebuildTask = new IndexRebuildTask(collectionId, this.documentIndexer);
                return rebuildTask;
            }
            return null;
        }
        return null;
    }

    private Vector<String> getRebuildingCollectionIds() {
        Vector<String> collectionIds = GlobalSystem.getSingleInstance().getConfigurationManager().getCollectionIds();
        for (int i = collectionIds.size() - 1; i >= 0; --i) {
            boolean isRebuilding = false;
            try {
                CollectionConfiguration config = GlobalSystem.getSingleInstance().getConfigurationManager().getCollection(collectionIds.elementAt(i));
                isRebuilding = config.isRebuilding();
            }
            catch (ConfigurationManagerException e) {
                isRebuilding = false;
            }
            if (isRebuilding) continue;
            collectionIds.remove(i);
        }
        return collectionIds;
    }

    private IndexerTask getNextAnchorTextTask() {
        Vector<String> anchorTextIds = this.getAnchorTextCollectionIds();
        this.filterWaitingTasks(anchorTextIds);
        this.filterActiveTasks(anchorTextIds);
        this.filterQuiescedTasks(anchorTextIds);
        if (this.getBoolean(this.anchorTextProbability)) {
            String collectionId = this.randomPick(anchorTextIds);
            if (collectionId != null) {
                if (this.getWaitingTask(collectionId) == null) {
                    AnchorTextTask task = new AnchorTextTask(collectionId, this.documentIndexer);
                    return task;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private String randomPick(Vector<String> set) {
        if (set.size() == 0) {
            return null;
        }
        if (set.size() == 1) {
            return set.elementAt(0);
        }
        int pick = this.generator.nextInt(set.size());
        return set.elementAt(pick);
    }

    private boolean getBoolean(double probability) {
        double value = this.generator.nextDouble();
        return value < probability;
    }

    @Override
    public void run() {
        this.indexSweeper = new Sweeper(this);
        for (int i = 0; i < this.indexers.length; ++i) {
            this.indexers[i] = new IndexerThread(this, 5000, "IndexerThread-" + i);
            this.indexers[i].setPriority(1);
            this.indexers[i].start();
        }
        this.indexSweeper.start();
    }

    public void stop() {
        this.stop(false);
    }

    public boolean isRunning() {
        boolean running = false;
        if (this.indexSweeper != null) {
            running = this.indexSweeper.isAlive();
        }
        return running;
    }

    public void stop(boolean force) {
        if (force) {
            this.forceStop();
        } else {
            this.stopAndWait(true);
        }
    }

    private void forceStop() {
        if (this.indexers != null) {
            for (int i = 0; i < this.indexers.length; ++i) {
                this.indexers[i].stopProcessing(true);
            }
        }
        try {
            if (this.documentIndexer != null) {
                this.documentIndexer.shutdown(true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAndWait(boolean shutdown) {
        if (this.indexers != null) {
            int i;
            for (i = 0; i < this.indexers.length; ++i) {
                this.indexers[i].stopProcessing(false);
            }
            for (i = 0; i < this.indexers.length; ++i) {
                try {
                    this.indexers[i].join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.indexSweeper.stopProcessing();
        try {
            this.indexSweeper.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (shutdown) {
            try {
                this.documentIndexer.shutdown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class Sweeper
    extends Thread {
        private IndexManager manager;
        private volatile boolean stop;

        public Sweeper(IndexManager manager) {
            super("IdleIndexSweeper");
            this.manager = manager;
            this.stop = false;
        }

        public void run() {
            while (!this.stop) {
                try {
                    Sweeper.sleep(1000L);
                    this.manager.documentIndexer.sweepIndex(60);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopProcessing() {
            this.stop = true;
        }
    }
}

