/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.manager;

import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.QueuedDocument;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.ShutdownPendingException;
import com.ibm.es.nuvo.manager.IndexerTask;
import java.util.LinkedList;
import java.util.ListIterator;

public class DocumentIndexerTask
extends IndexerTask {
    private DocumentQueueInterface documentQueue;
    private LinkedList<QueuedDocument> list;
    private long documentCounter;
    private long idleCount;

    public DocumentIndexerTask(String collectionId, DocumentIndexer indexer, DocumentQueueInterface queue) {
        super(collectionId, indexer);
        this.documentQueue = queue;
        this.list = new LinkedList();
        this.idleCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ConfigurationManagerException, IndexerException, ShutdownPendingException {
        this.list.clear();
        this.documentQueue.getDocuments(this.getCollectionId(), this.list);
        if (this.list.size() == 0) {
            ++this.idleCount;
            return;
        }
        this.idleCount = 0L;
        LinkedList<BaseDocument> documents = new LinkedList<BaseDocument>();
        ListIterator iterator = this.list.listIterator();
        while (iterator.hasNext()) {
            QueuedDocument queuedDocument = (QueuedDocument)iterator.next();
            documents.add(queuedDocument.getDocument());
        }
        try {
            this.getDocumentIndexer().processDocuments(this.getCollectionId(), documents);
        }
        finally {
            if (!this.isForceStop()) {
                this.documentQueue.removeDocuments(this.getCollectionId(), this.list);
                this.documentCounter += (long)this.list.size();
            }
        }
    }

    public long getDocumentsProcessed() {
        return this.documentCounter;
    }

    public long getIdleCount() {
        return this.idleCount;
    }

    public boolean isMultiInstances() {
        return true;
    }
}

