/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.manager;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.ShutdownPendingException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.manager.IndexerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class AnchorTextTask
extends IndexerTask {
    private static final int DefaultMaxAnchorTextTime = 10000;

    public AnchorTextTask(String collectionId, DocumentIndexer indexer) {
        super(collectionId, indexer);
    }

    public void run() throws ConfigurationManagerException, IndexerException, ShutdownPendingException {
        IndexDescriptor descriptor = AnchorTextTask.getAnchorTextIndexDescriptor(this.getCollectionId());
        if (descriptor != null) {
            int time;
            block4: {
                String anchorTextTimeString = descriptor.getProperty("MaxAnchorTextProcessingTimeInMillis");
                time = 10000;
                try {
                    if (anchorTextTimeString != null) {
                        time = Integer.parseInt(anchorTextTimeString);
                    }
                }
                catch (NumberFormatException e) {
                    time = 10000;
                    if (!Loggers.logger.isLoggable(Level.WARNING)) break block4;
                    IndexerException indexerException = new IndexerException(new Message("I0012W.INVALID_VALUE_MAX_ANCHOR_TEXT_PROCESSING_TIME"));
                    Loggers.logger.log(indexerException);
                }
            }
            this.getDocumentIndexer().processAnchorText(this.getCollectionId(), time, TimeUnit.MILLISECONDS);
        }
    }

    public static IndexDescriptor getAnchorTextIndexDescriptor(String collectionId) throws ConfigurationManagerException {
        CollectionConfiguration config = ConfigurationManager.getConfigurationManager().getCollection(collectionId);
        return config.getIndexDescriptorFor(IndexDescriptor.IndexType.Anchor);
    }

    public boolean isMultiInstances() {
        return false;
    }
}

