/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.logging.CompactLogRecordWalker;
import com.ibm.es.nuvo.logging.LogWalker;
import com.ibm.es.nuvo.logging.LogWalkerFilter;
import com.ibm.es.nuvo.logging.LoggedQuery;
import com.ibm.es.nuvo.logging.LoggedQueryFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryLogWalker
implements LogWalker<Object> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CompactLogRecordWalker logWalker = null;
    private LoggedQueryFilter filter = null;
    private LoggedQuery previousQuery = null;
    private LoggedQuery nextQuery = null;

    public QueryLogWalker(File logFile) throws FileNotFoundException, IOException {
        this.logWalker = new CompactLogRecordWalker(logFile);
    }

    public QueryLogWalker(File logFile, CompactLogRecordWalker.StartPosition position) throws FileNotFoundException, IOException {
        this.logWalker = new CompactLogRecordWalker(logFile, position);
    }

    public void setFilter(LoggedQueryFilter filter) {
        this.filter = filter;
    }

    public void close() {
        this.logWalker.close();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (null != this.nextQuery) {
            return true;
        }
        this.logWalker.mark();
        this.nextQuery = this.next();
        this.logWalker.moveToLastMark();
        return this.nextQuery != null;
    }

    @Override
    public LoggedQuery next() throws IOException {
        this.nextQuery = null;
        while (this.logWalker.hasNext()) {
            LogRecord record = this.logWalker.next();
            try {
                LoggedQuery query = new LoggedQuery(record);
                if (null != this.filter && !this.filter.accept(query)) continue;
                return query;
            }
            catch (InvalidArgumentException invalidArgumentException) {
            }
        }
        return null;
    }

    @Override
    public void skipToEnd() throws IOException {
        this.logWalker.skipToEnd();
    }

    @Override
    public boolean hasPrevious() throws IOException {
        if (null != this.previousQuery) {
            return true;
        }
        this.logWalker.mark();
        this.previousQuery = this.previous();
        this.logWalker.moveToLastMark();
        return this.previousQuery != null;
    }

    @Override
    public LoggedQuery previous() throws IOException {
        this.previousQuery = null;
        while (this.logWalker.hasPrevious()) {
            LogRecord record = this.logWalker.previous();
            try {
                LoggedQuery query = new LoggedQuery(record);
                if (null != this.filter && !this.filter.accept(query)) continue;
                return query;
            }
            catch (InvalidArgumentException invalidArgumentException) {
            }
        }
        return null;
    }

    @Override
    public void skipToStart() throws IOException {
        this.logWalker.skipToStart();
    }

    @Override
    public boolean moveBackwardPastPrevious() throws IOException {
        LoggedQuery skipped = this.previous();
        return null != skipped;
    }

    @Override
    public boolean moveForwardPastNext() throws IOException {
        LoggedQuery skipped = this.next();
        return null != skipped;
    }

    @Override
    public void setFilter(LogWalkerFilter filter) {
        if (filter instanceof LoggedQueryFilter) {
            this.setFilter((LoggedQueryFilter)filter);
        }
    }
}

