/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.logging.CompactLogRecordFormatter;
import com.ibm.es.nuvo.logging.DynamicFileHandler;
import com.ibm.es.nuvo.logging.DynamicFileHandlerException;
import java.io.File;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerWrapper {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected Logger logger = null;
    protected DynamicFileHandler dynamicFileHandler = null;

    public LoggerWrapper(String loggerName, String directory, String logFilePrefix) {
        this(Logger.getLogger(loggerName), directory, logFilePrefix);
    }

    public LoggerWrapper(Logger logger, String directory, String logFilePrefix) {
        this.logger = logger;
        this.dynamicFileHandler = new DynamicFileHandler(directory, logFilePrefix);
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(Level.INFO);
        this.logger.addHandler(this.dynamicFileHandler);
    }

    public void initialize() throws DynamicFileHandlerException {
        this.dynamicFileHandler.setLimits(0x800000, 5);
    }

    public void initialize(int newLimit, int newCount) throws DynamicFileHandlerException {
        this.dynamicFileHandler.setLimits(newLimit, newCount);
    }

    public void flush() {
        this.dynamicFileHandler.flush();
    }

    public void close() {
        this.dynamicFileHandler.close();
    }

    public void setLimits(int newLimit, int newCount) throws DynamicFileHandlerException {
        this.dynamicFileHandler.setLimits(newLimit, newCount);
    }

    public void setLevel(Level newLevel) throws ConfigurationManagerException {
        this.logger.setLevel(newLevel);
        this.dynamicFileHandler.setLevel(newLevel);
        SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
        SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.SystemSettings);
        systemSettings.setLoggerLevel(this.getName(), newLevel);
        settingsConfigMgr.updateStateObject(SettingsConfigurationManager.SettingsType.SystemSettings, systemSettings);
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public int getCount() {
        return this.dynamicFileHandler.getCount();
    }

    public int getLimit() {
        return this.dynamicFileHandler.getLimit();
    }

    public CompactLogRecordFormatter getCompactLogRecordFormatter() {
        Formatter formatter = this.dynamicFileHandler.getFormatter();
        if (null != formatter && formatter instanceof CompactLogRecordFormatter) {
            return (CompactLogRecordFormatter)formatter;
        }
        return null;
    }

    public void setPrintingStackTrace(boolean value) {
        this.getCompactLogRecordFormatter().setPrintingStackTrace(value);
    }

    public boolean isPrintingStackTrace() {
        this.getCompactLogRecordFormatter().isPrintingStackTrace();
        return false;
    }

    public File[] getLogFiles() {
        return this.dynamicFileHandler.getLogFiles();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void setProperties(SystemSettings systemSettings) {
        this.logger.setLevel(systemSettings.getLoggerLevel(this.getName()));
    }

    public void setLogRotationNotifier(Object objectToNotify) {
        this.dynamicFileHandler.setLogRotationNotifier(objectToNotify);
    }

    public static void main(String[] args) {
    }
}

