/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.common.Message;
import java.util.Date;
import java.util.logging.LogRecord;

public class LoggedQuery {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String Key = "S0001I.QUERY_LOG";
    public static final String Key2 = "S0096I.CLICKED_RESULTS_LOG";
    private String currentKey = "";
    private String queryText = null;
    private String clientIP = null;
    private String userID = null;
    private String locale = null;
    private int resultsCount = 0;
    private int resultStart = 0;
    private String collectionID = null;
    private long msQueryResponseTime = 0L;
    private long timeStamp = 0L;
    private String clickThroughTracking = "0";
    private String sessionId = "";
    private String clickedResult = null;
    private String resultTitle = null;
    private String charset = null;
    private String mimeType = null;
    private String spaceId = null;
    private LogRecord logRecord = null;

    public LoggedQuery(String queryText, String clientIP, String locale, int resultsCount, int resultStart, String collectionID, long msQueryResponseTime) {
        this(queryText, clientIP, locale, resultsCount, resultStart, collectionID, msQueryResponseTime, new Date().getTime(), "0", "", "");
    }

    public LoggedQuery(String queryText, String clientIP, String locale, int resultsCount, int resultStart, String collectionID, long msQueryResponseTime, String clickThroughTracking, String sessionId, String userID) {
        this(queryText, clientIP, locale, resultsCount, resultStart, collectionID, msQueryResponseTime, new Date().getTime(), clickThroughTracking, sessionId, userID);
    }

    public LoggedQuery(String queryText, String clientIP, String locale, int resultsCount, int resultStart, String collectionID, long msQueryResponseTime, long timeStamp, String clickThroughTracking, String sessionId, String userID) {
        this.queryText = queryText;
        this.clientIP = clientIP;
        this.locale = locale;
        this.resultsCount = resultsCount;
        this.resultStart = resultStart;
        this.collectionID = collectionID;
        this.msQueryResponseTime = msQueryResponseTime;
        this.timeStamp = timeStamp;
        this.clickThroughTracking = clickThroughTracking;
        this.sessionId = sessionId;
        this.userID = userID;
        this.currentKey = Key;
    }

    public LoggedQuery(String sessionId, String queryText, String clickedResult, String resultTitle, String charset, String mimeType, String spaceId, String collectionID) {
        this(sessionId, queryText, clickedResult, resultTitle, charset, mimeType, spaceId, collectionID, new Date().getTime());
    }

    public LoggedQuery(String sessionId, String queryText, String clickedResult, String resultTitle, String charset, String mimeType, String spaceId, String collectionID, long timeStamp) {
        this.sessionId = sessionId;
        this.queryText = queryText;
        this.clickedResult = clickedResult;
        this.resultTitle = resultTitle;
        this.timeStamp = timeStamp;
        this.charset = charset;
        this.mimeType = mimeType;
        this.spaceId = spaceId;
        this.collectionID = collectionID;
        this.currentKey = Key2;
    }

    public void parseLogRecordArgumets_2(Message msg, LogRecord logRec) {
        this.currentKey = Key2;
        Object[] args = msg.getArguments();
        this.sessionId = args[0] instanceof String ? (String)args[0] : args[0].toString();
        this.queryText = args[1] instanceof String ? (String)args[1] : args[1].toString();
        this.clickedResult = args[2] instanceof String ? (String)args[2] : args[2].toString();
        long l = this.timeStamp = args[3] instanceof Long ? ((Long)args[3]).longValue() : logRec.getMillis();
        this.resultTitle = args.length > 4 ? (args[4] instanceof String ? (String)args[4] : args[4].toString()) : "";
        if (args.length > 5) {
            String string = this.collectionID = args[5] instanceof String ? (String)args[5] : args[5].toString();
        }
        if (args.length > 6) {
            String string = this.spaceId = args[6] instanceof String ? (String)args[6] : args[6].toString();
        }
        if (args.length > 7) {
            String string = this.charset = args[7] instanceof String ? (String)args[7] : args[7].toString();
        }
        if (args.length > 8) {
            this.mimeType = args[8] instanceof String ? (String)args[8] : args[8].toString();
        }
        this.logRecord = logRec;
    }

    public void parseLogRecordArgumets(Message msg, LogRecord logRec) {
        this.currentKey = Key;
        Object[] args = msg.getArguments();
        this.queryText = args[0] instanceof String ? (String)args[0] : args[0].toString();
        this.clientIP = args[1] instanceof String ? (String)args[1] : args[1].toString();
        this.locale = args[0] instanceof String ? (String)args[2] : args[2].toString();
        this.resultsCount = args[3] instanceof Long ? ((Long)args[3]).intValue() : 0;
        this.resultStart = args[4] instanceof Long ? ((Long)args[4]).intValue() : 0;
        String string = this.collectionID = args[5] instanceof String ? (String)args[5] : args[5].toString();
        if (args.length >= 7) {
            long l = this.msQueryResponseTime = args[6] instanceof Long ? (Long)args[6] : 0L;
        }
        if (args.length >= 8) {
            long l = this.timeStamp = args[7] instanceof Long ? ((Long)args[7]).longValue() : logRec.getMillis();
        }
        if (args.length >= 9) {
            String string2 = this.clickThroughTracking = args[8] instanceof String ? (String)args[8] : args[8].toString();
        }
        if (args.length >= 10) {
            String string3 = this.sessionId = args[9] instanceof String ? (String)args[9] : args[9].toString();
        }
        if (args.length >= 11) {
            this.userID = args[10] instanceof String ? (String)args[10] : args[10].toString();
        }
        this.logRecord = logRec;
    }

    public LoggedQuery(LogRecord logRecord) throws InvalidArgumentException {
        Message msg = new Message(logRecord);
        if (msg.getKey().equals(Key)) {
            this.parseLogRecordArgumets(msg, logRecord);
            return;
        }
        if (msg.getKey().equals(Key2)) {
            this.parseLogRecordArgumets_2(msg, logRecord);
            return;
        }
        throw new InvalidArgumentException("message_key", msg.getKey());
    }

    public String getQueryText() {
        return this.queryText;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getUserID() {
        if (this.userID != null) {
            return this.userID;
        }
        return "";
    }

    public String getLocaleString() {
        return this.locale;
    }

    public int getResultsCount() {
        return this.resultsCount;
    }

    public int getResultsStart() {
        return this.resultStart;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public long getQueryResponseTime() {
        return this.msQueryResponseTime;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getClickThroughTracking() {
        return this.clickThroughTracking;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getClickedResult() {
        return this.clickedResult;
    }

    public String getResultTitle() {
        return this.resultTitle;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public LogRecord getLogRecord() {
        return this.logRecord;
    }

    public Message toMessage() {
        Message msg = new Message(this.currentKey);
        if (msg.getKey().equals(Key)) {
            msg.addArgument(this.queryText);
            msg.addArgument(this.clientIP);
            msg.addArgument(this.locale);
            msg.addArgument(this.resultsCount);
            msg.addArgument(this.resultStart);
            msg.addArgument(this.collectionID);
            msg.addArgument(this.msQueryResponseTime);
            msg.addArgument(this.timeStamp);
            msg.addArgument(this.clickThroughTracking);
            msg.addArgument(this.sessionId);
            msg.addArgument(this.userID);
        }
        if (msg.getKey().equals(Key2)) {
            msg.addArgument(this.sessionId);
            msg.addArgument(this.queryText);
            msg.addArgument(this.clickedResult);
            msg.addArgument(this.timeStamp);
            msg.addArgument(this.resultTitle);
            msg.addArgument(this.collectionID);
            msg.addArgument(this.spaceId);
            msg.addArgument(this.charset);
            msg.addArgument(this.mimeType);
        }
        return msg;
    }

    public boolean equals(Object toCompare) {
        if (!(toCompare instanceof LoggedQuery)) {
            return false;
        }
        LoggedQuery object = (LoggedQuery)toCompare;
        return this.queryText.equals(object.queryText) && this.clientIP.equals(object.clientIP) && this.locale.equals(object.locale) && this.resultsCount == object.resultsCount && this.resultStart == object.resultStart && this.collectionID.equals(object.collectionID) && this.msQueryResponseTime == object.msQueryResponseTime && this.timeStamp == object.timeStamp && this.clickThroughTracking.equals(object.clickThroughTracking) && this.sessionId.equals(object.sessionId) && this.userID.equals(object.userID) && this.spaceId.equals(object.spaceId) && this.charset.equals(object.charset) && this.mimeType.equals(object.mimeType);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.queryText);
        int separator = 44;
        builder.append(',');
        builder.append(this.clientIP);
        builder.append(',');
        builder.append(this.locale);
        builder.append(',');
        builder.append(this.resultsCount);
        builder.append(',');
        builder.append(this.resultStart);
        builder.append(',');
        builder.append(this.collectionID);
        builder.append(',');
        builder.append(this.msQueryResponseTime);
        builder.append(',');
        builder.append(this.timeStamp);
        builder.append(',');
        builder.append(this.clickThroughTracking);
        builder.append(',');
        builder.append(this.sessionId);
        builder.append(',');
        builder.append(this.userID);
        builder.append(',');
        builder.append(this.spaceId);
        builder.append(',');
        builder.append(this.charset);
        builder.append(',');
        builder.append(this.mimeType);
        System.out.println(" +++ LogQuery::toString () :" + builder.toString());
        return builder.toString();
    }

    public boolean isQueryRecord() {
        return this.currentKey.equals(Key);
    }

    public boolean isClickedResultRecord() {
        return this.currentKey.equals(Key2);
    }
}

