/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.CompactLogRecordIterator;
import com.ibm.es.nuvo.logging.LogRecordFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.LogRecord;

public final class LogViewer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String USAGE = "Usage: logformatter.{bat|sh} -f logfile [-options]\n\n  Where:\n    -f logfile\n       The log file to format\n    -l locale <for example \"en_US\", \"ja_JP\">\n       The locale to use when writing the reformatted messages. The system\n       default locale will be used if a locale is not specified (optional)\n    -o outputfile\n       The output file where the reformatted log messages will be written.\n       using UTF-8. Standard output will be used if not specified (optional)\n    -? Prints this help message (optional)\n    -v Specifies the verbose mode that will display debugging\n       messages (optional)";
    private static boolean verbose = false;
    private static ArrayList<String> logFiles = new ArrayList(4);
    private static String outputFileName = null;
    private static final String encoding = "UTF-8";
    private static String localeStr = null;
    private static Locale locale = null;
    private static PrintWriter writer = null;

    private LogViewer() {
    }

    private static void displayUsage(Locale inLocale) {
        if (inLocale == null) {
            inLocale = Locale.getDefault();
            if (verbose) {
                System.out.println("Using locale: " + inLocale.toString());
            }
        }
        Message msg = new Message("G0010I.LOGVIEWER_USAGE");
        System.out.println();
        if (null == msg.getText(inLocale)) {
            if (verbose) {
                System.out.println("Using the default USAGE text");
            }
            System.out.println(USAGE);
        } else {
            System.out.println(msg.getFormattedText(inLocale));
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            File logFile;
            for (int argCount = 0; argv != null && argCount < argv.length; ++argCount) {
                String argPtr = argv[argCount];
                if (argPtr.length() < 2 || !argPtr.startsWith("-")) {
                    if (verbose) {
                        System.out.println("ERROR: Invalid option specified: " + argPtr);
                    }
                    LogViewer.displayUsage(locale);
                    Message msg = new Message("G0007E.INVALID_ARGUMENT");
                    msg.addArgument(argPtr);
                    ExtendedException ee = new ExtendedException(msg);
                    throw ee;
                }
                if (argPtr.compareTo("-f") == 0) {
                    int index;
                    if (++argCount < argv.length) {
                        logFiles.add(argv[argCount]);
                    }
                    for (index = argCount + 1; index < argv.length && !argv[index].startsWith("-"); ++index) {
                        logFiles.add(argv[index]);
                    }
                    argCount = index - 1;
                    continue;
                }
                if (argPtr.compareTo("-l") == 0) {
                    if (++argCount >= argv.length) continue;
                    localeStr = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo("-o") == 0) {
                    if (++argCount >= argv.length) continue;
                    outputFileName = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo("-v") == 0) {
                    verbose = true;
                    continue;
                }
                if (argPtr.compareTo("-?") == 0) {
                    LogViewer.displayUsage(locale);
                    return;
                }
                if (verbose) {
                    System.out.println("ERROR: Invalid option specified: " + argPtr);
                }
                LogViewer.displayUsage(locale);
                Message msg = new Message("G0007E.INVALID_ARGUMENT");
                msg.addArgument(argPtr);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            if (logFiles.size() == 0) {
                if (verbose) {
                    System.out.println("ERROR: No log file was specified.");
                }
                LogViewer.displayUsage(locale);
                Message msg = new Message("G0008E.MISSING_ARGUMENT");
                msg.addArgument("-f");
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            if (outputFileName == null) {
                try {
                    writer = new PrintWriter(System.out, true);
                }
                catch (Exception e) {
                    if (verbose) {
                        System.out.println("ERROR: Couldn't create a PrintWriter object using System.out");
                    }
                    e.printStackTrace();
                    if (outputFileName != null && writer != null) {
                        writer.close();
                    }
                    return;
                }
            }
            String canOutputFile = new File(outputFileName).getCanonicalPath();
            for (String logFileName : logFiles) {
                logFile = new File(logFileName);
                if (!canOutputFile.equals(logFile.getCanonicalPath())) continue;
                if (verbose) {
                    System.out.println("ERROR: Input and output files are the same - Input File: " + logFileName + " Output " + "File: " + outputFileName + " Canonical Name: " + canOutputFile);
                }
                LogViewer.displayUsage(locale);
                Message msg = new Message("G0003E.SAME_INPUT_OUTPUT_FILE");
                msg.addArgument(logFileName);
                msg.addArgument(outputFileName);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            try {
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFileName));
                OutputStreamWriter osw = null;
                osw = new OutputStreamWriter((OutputStream)outputStream, encoding);
                writer = new PrintWriter((Writer)osw, true);
            }
            catch (Exception e) {
                if (verbose) {
                    System.out.println("ERROR: Couldn't open file " + outputFileName + " for output");
                }
                e.printStackTrace();
                if (outputFileName != null && writer != null) {
                    writer.close();
                }
                return;
            }
            if (null != localeStr && localeStr.length() >= 2) {
                String lang = localeStr.substring(0, 2);
                if (localeStr.length() >= 5) {
                    String country = localeStr.substring(3, 5);
                    locale = new Locale(lang, country);
                } else {
                    locale = new Locale(lang);
                }
            }
            if (null == locale) {
                locale = Locale.getDefault();
            }
            if (verbose) {
                System.out.println("Verbose mode is enabled");
            }
            for (String logFileName : logFiles) {
                File logFile2 = new File(logFileName);
                if (logFile2.isFile()) continue;
                if (verbose) {
                    System.out.println("ERROR: The specified log file is not a file: " + logFileName);
                }
                LogViewer.displayUsage(locale);
                Message msg = new Message("G0009E.ARGUMENT_INVALID_VALUE");
                msg.addArgument("-f");
                msg.addArgument(logFileName);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            Iterator<String> iterator = logFiles.iterator();
            LogRecordFormatter formatter = new LogRecordFormatter(locale);
            while (iterator.hasNext()) {
                String logFileName;
                logFileName = iterator.next();
                logFile = new File(logFileName);
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(logFile));
                CompactLogRecordIterator logIterator = new CompactLogRecordIterator(is);
                writer.println(formatter.getFormatHeader());
                writer.println();
                ExtendedException lastErr = null;
                int count = 0;
                while (logIterator.hasNext()) {
                    LogRecord record;
                    ++count;
                    if (verbose) {
                        System.out.println("Log Record: " + count);
                    }
                    if (null == (record = logIterator.next())) {
                        lastErr = logIterator.getLastError();
                        if (lastErr == null) continue;
                        System.out.println(lastErr.getFormattedText(locale, true));
                        System.out.flush();
                        lastErr = null;
                        continue;
                    }
                    boolean printStackTrace = true;
                    writer.println(formatter.format(record, printStackTrace));
                    writer.println();
                }
            }
        }
        catch (ExtendedException ee) {
            if (verbose) {
                System.err.println("ERROR: An ExtendedExeption was caught");
            }
            System.err.println(ee.getFormattedText(locale));
            return;
        }
        catch (Throwable t) {
            if (verbose) {
                System.out.println("ERROR: An unknown exception was caught." + t.getMessage());
            }
            t.printStackTrace(System.err);
            return;
        }
        finally {
            if (outputFileName != null && writer != null) {
                writer.close();
            }
        }
    }
}

