/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.DateTimeFormatter;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class LogRecordFormatter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String FORMAT_HEADER = "[DATE] [TIME] [SequenceNumber] [ThreadID] [Level]" + LINE_SEPARATOR + "[LoggerName] [SourceClass] [SourceMethod]" + LINE_SEPARATOR + "Message Text";
    private Locale locale = null;
    private DateFormat dateFormat = null;
    private DateFormat timeFormat = null;
    HashMap<Level, String> levelMap = null;

    public LogRecordFormatter() {
        this(Locale.getDefault());
    }

    public LogRecordFormatter(Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.dateFormat = DateTimeFormatter.getDateFormatter(this.locale);
        this.timeFormat = DateTimeFormatter.getTimeFormatter(this.locale);
        this.initLevelMap();
    }

    public String format(LogRecord logRecord) {
        return this.format(logRecord, false);
    }

    public String format(LogRecord logRecord, boolean printStackTrace) {
        StringBuilder formattedText = new StringBuilder();
        formattedText.append(this.dateFormat.format(logRecord.getMillis()));
        formattedText.append(" ");
        formattedText.append(this.timeFormat.format(logRecord.getMillis()));
        formattedText.append(" [" + logRecord.getSequenceNumber() + "]");
        formattedText.append(" [" + logRecord.getThreadID() + "]");
        formattedText.append(" [" + this.levelMap.get(logRecord.getLevel()) + "]");
        formattedText.append(LINE_SEPARATOR);
        formattedText.append("[" + logRecord.getLoggerName() + "]");
        formattedText.append(" [" + logRecord.getSourceClassName() + "]");
        formattedText.append(" [" + logRecord.getSourceMethodName() + "]");
        formattedText.append(LINE_SEPARATOR);
        Throwable thrown = logRecord.getThrown();
        if (null == thrown) {
            Message logRecordMsg = new Message(logRecord);
            formattedText.append(logRecordMsg.getFormattedTextWithDisplayKey(this.locale));
        } else {
            ExtendedException.appendFormattedText(formattedText, thrown, this.locale, printStackTrace);
        }
        return formattedText.toString();
    }

    public String getFormatHeader() {
        return FORMAT_HEADER;
    }

    private void initLevelMap() {
        this.levelMap = new HashMap(8);
        String translatedSevere = Message.getText("A0135I.admin.log.severe", this.locale);
        if (null == translatedSevere) {
            translatedSevere = Level.SEVERE.toString();
        }
        this.levelMap.put(Level.SEVERE, translatedSevere);
        String translatedWarning = Message.getText("A0136I.admin.log.warn", this.locale);
        if (null == translatedWarning) {
            translatedWarning = Level.WARNING.toString();
        }
        this.levelMap.put(Level.WARNING, translatedWarning);
        String translatedInfo = Message.getText("A0137I.admin.log.info", this.locale);
        if (null == translatedInfo) {
            translatedInfo = Level.INFO.toString();
        }
        this.levelMap.put(Level.INFO, translatedInfo);
        String translatedConfig = Message.getText("A0174I.admin.log.config", this.locale);
        if (null == translatedConfig) {
            translatedConfig = Level.CONFIG.toString();
        }
        this.levelMap.put(Level.CONFIG, translatedConfig);
        String translatedFine = Message.getText("A0138I.admin.log.fine", this.locale);
        if (null == translatedFine) {
            translatedFine = Level.FINE.toString();
        }
        this.levelMap.put(Level.FINE, translatedFine);
        String translatedFiner = Message.getText("A0139I.admin.log.finer", this.locale);
        if (null == translatedFiner) {
            translatedFiner = Level.FINER.toString();
        }
        this.levelMap.put(Level.FINER, translatedFiner);
        String translatedFinest = Message.getText("A0140I.admin.log.finest", this.locale);
        if (null == translatedFinest) {
            translatedFinest = Level.FINEST.toString();
        }
        this.levelMap.put(Level.FINEST, translatedFinest);
        String translatedOff = Message.getText("A0141I.admin.log.off", this.locale);
        if (null == translatedOff) {
            translatedOff = Level.OFF.toString();
        }
        this.levelMap.put(Level.OFF, translatedOff);
    }
}

