/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.logging.CompactLogRecordWalker;
import com.ibm.es.nuvo.logging.LogRecordFilter;
import com.ibm.es.nuvo.logging.LogWalkerFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.LogRecord;

public class FilterCompactLogRecordWalker
extends CompactLogRecordWalker {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private LogRecordFilter filter = null;
    private LogRecord previousRecord = null;
    private LogRecord nextRecord = null;

    public FilterCompactLogRecordWalker(File logFile) throws FileNotFoundException, IOException {
        this(logFile, CompactLogRecordWalker.StartPosition.StartAtBegining);
    }

    public FilterCompactLogRecordWalker(File logFile, CompactLogRecordWalker.StartPosition position) throws FileNotFoundException, IOException {
        super(logFile, position);
    }

    public void setFilter(LogRecordFilter filter) {
        this.filter = filter;
    }

    public boolean hasNext() throws IOException {
        if (null != this.nextRecord) {
            return true;
        }
        super.mark();
        this.nextRecord = this.next();
        super.moveToLastMark();
        return this.nextRecord != null;
    }

    public LogRecord next() throws IOException {
        this.nextRecord = null;
        while (super.hasNext()) {
            LogRecord record = super.next();
            if (null != this.filter && !this.filter.accept(record)) continue;
            return record;
        }
        return null;
    }

    public boolean hasPrevious() throws IOException {
        if (null != this.previousRecord) {
            return true;
        }
        super.mark();
        this.previousRecord = this.previous();
        super.moveToLastMark();
        return this.previousRecord != null;
    }

    public LogRecord previous() throws IOException {
        this.previousRecord = null;
        while (super.hasPrevious()) {
            LogRecord record = super.previous();
            if (null != this.filter && !this.filter.accept(record)) continue;
            return record;
        }
        return null;
    }

    public boolean moveBackwardPastPrevious() throws IOException {
        LogRecord skipped = this.previous();
        return null != skipped;
    }

    public boolean moveForwardPastNext() throws IOException {
        LogRecord skipped = this.next();
        return null != skipped;
    }

    public void setFilter(LogWalkerFilter filter) {
        if (filter instanceof LogRecordFilter) {
            this.setFilter((LogRecordFilter)filter);
        }
    }
}

